/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.object;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.exception.NoSystemUnderTestException;
import fitlibrary.exception.method.MissingMethodException;
import fitlibrary.global.PlugBoard;
import fitlibrary.object.DomainObjectSetUpTraverse;
import fitlibrary.object.DomainTraverse;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.SwitchingEvaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;

public class DomainCheckTraverse
extends Traverse
implements SwitchingEvaluator {
    private DomainTraverse domainTraverse;

    public DomainCheckTraverse() {
    }

    public DomainCheckTraverse(Object sut) {
        super(sut);
    }

    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        table.error(testResults, (Throwable)new RuntimeException("Don't expect to have this called!"));
        return null;
    }

    public void setDomainTraverse(DomainTraverse domainTraverse) {
        this.domainTraverse = domainTraverse;
    }

    public void runTable(Table table, TableListener tableListener) {
        if (this.switchOnExpected(table)) {
            this.domainTraverse.setCurrentAction();
            return;
        }
        try {
            for (int rowNo = 0; rowNo < table.size(); ++rowNo) {
                Row row = table.row(rowNo);
                if (row.text(0, this).equals("comment")) {
                    return;
                }
                this.processRow(row, tableListener.getTestResults());
            }
        }
        catch (Exception e) {
            table.error(tableListener, e);
        }
    }

    private void processRow(Row row, TestResults testResults) {
        for (int i = 0; i < row.size(); i += 2) {
            Cell cell = row.cell(i);
            Cell cell2 = row.cell(i + 1);
            if (DomainObjectSetUpTraverse.givesClass(cell, this)) {
                if (this.getSystemUnderTest() == null) {
                    throw new NoSystemUnderTestException();
                }
                this.checkClass(testResults, cell, cell2);
                continue;
            }
            String name = cell.text(this);
            try {
                TypedObject typedSystemUnderTest = this.getTypedSystemUnderTest();
                if (typedSystemUnderTest == null) {
                    throw new NoSystemUnderTestException();
                }
                CalledMethodTarget target = typedSystemUnderTest.findGetterOnTypedObject(name, this);
                target.invokeAndCheck(new Row(), cell2, testResults, false);
                continue;
            }
            catch (MissingMethodException ex) {
                cell.error(testResults, ex);
            }
        }
    }

    private void checkClass(TestResults testResults, Cell cell, Cell classCell) {
        String typeName = classCell.text(this);
        try {
            Class<?> sutClass = PlugBoard.lookupTarget.findClassFromFactoryMethod(this, this.getTypedSystemUnderTest().getClassType(), typeName);
            if (this.getSystemUnderTest().getClass().equals(sutClass)) {
                classCell.pass(testResults);
            } else {
                classCell.fail(testResults);
            }
        }
        catch (Exception e) {
            cell.error(testResults, e);
        }
    }

    private boolean switchOnExpected(Table table) {
        return this.domainTraverse != null && table.size() == 1 && table.row(0).size() == 1 && table.row(0).cell(0).matchesText("expected", this);
    }
}

