/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.object;

import fitlibrary.closure.Closure;
import fitlibrary.global.PlugBoard;
import fitlibrary.object.DomainObjectCheckTraverse;
import fitlibrary.object.DomainObjectSetUpTraverse;
import fitlibrary.object.Finder;
import fitlibrary.parser.Parser;
import fitlibrary.table.Cell;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.TestResults;

public class DomainObjectParser
implements Parser {
    protected Evaluator evaluator;
    private Typed typed;
    private Finder finder;

    public DomainObjectParser(Evaluator evaluator, Typed typed) {
        this.evaluator = evaluator;
        this.typed = typed;
        this.finder = typed.getFinder(evaluator);
    }

    public TypedObject parseTyped(Cell cell, TestResults testResults) throws Exception {
        return this.typed.typedObject(this.parse(cell, testResults));
    }

    private Object parse(Cell cell, TestResults testResults) throws Exception {
        if (cell.hasEmbeddedTable()) {
            return this.parseTable(cell.getEmbeddedTable(), testResults);
        }
        return this.finder.find(cell.text(this.evaluator));
    }

    protected Object parseTable(Table embeddedTable, TestResults testResults) throws Exception {
        TypedObject newInstance = null;
        try {
            newInstance = this.typed.newTypedInstance();
        }
        catch (Exception ex) {
            try {
                Closure fixturingMethod = PlugBoard.lookupTarget.findFixturingMethod(this.evaluator, "newInstancePlugin", new Class[]{Class.class});
                if (fixturingMethod != null) {
                    newInstance = this.typed.typedObject(fixturingMethod.invoke(new Object[]{this.typed.asClass()}));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        DomainObjectSetUpTraverse setUp = new DomainObjectSetUpTraverse(newInstance, this.typed);
        if (newInstance != null) {
            setUp.setOuterContext(this.evaluator);
            setUp.callStartCreatingObjectMethod(newInstance);
        }
        setUp.interpretInnerTable(embeddedTable, this.evaluator, testResults);
        return setUp.getSystemUnderTest();
    }

    public boolean matches(Cell cell, Object result, TestResults testResults) throws Exception {
        if (result == null) {
            return !cell.hasEmbeddedTable() && cell.isBlank(this.evaluator);
        }
        if (cell.hasEmbeddedTable()) {
            return this.matchesTable(cell.getEmbeddedTable(), result, testResults);
        }
        return this.matches(this.parse(cell, testResults), result);
    }

    protected boolean matchesTable(Table table, Object result, TestResults testResults) {
        DomainObjectCheckTraverse traverse = new DomainObjectCheckTraverse(result, this.typed);
        return traverse.doesInnerTablePass(table, this.evaluator, testResults);
    }

    public boolean matches(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public String show(Object result) throws Exception {
        return this.finder.show(result);
    }

    public Evaluator traverse(TypedObject typedObject) {
        return new DomainObjectCheckTraverse(typedObject);
    }

    public boolean hasFinderMethod() {
        return this.finder.hasFinderMethod();
    }
}

