/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.object;

import fitlibrary.closure.Closure;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.global.PlugBoard;
import fitlibrary.object.Finder;
import fitlibrary.ref.EntityReference;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import fitlibrary.utility.ExtendedCamelCase;
import java.lang.reflect.InvocationTargetException;

public class NonGenericFinder
implements Finder {
    public static final String FIND = "find";
    public static final String SHOW = "show";
    private String findExceptionMessage;
    private Closure findIntMethod;
    private Closure findStringMethod;
    private Closure showMethod;
    private EntityReference referenceParser;

    public NonGenericFinder(Typed typed, Evaluator evaluator) {
        String shortClassName = typed.simpleClassName();
        this.referenceParser = EntityReference.create(shortClassName.toLowerCase());
        Class[] intArg = new Class[]{Integer.TYPE};
        Class[] stringArg = new Class[]{String.class};
        Class[] showArg = new Class[]{typed.asClass()};
        String findName = ExtendedCamelCase.camel("find " + shortClassName);
        String showMethodName = ExtendedCamelCase.camel("show " + shortClassName);
        String potentialClasses = PlugBoard.lookupTarget.identifiedClassesInOutermostContext(evaluator, true);
        this.findExceptionMessage = "EITHER " + shortClassName + " is (1) a Value Object. So missing parse method: " + "public static " + shortClassName + " parse(String s) { } in class " + typed.getClassName() + "; OR (2) an Entity. So missing finder method: " + "public " + shortClassName + " find" + shortClassName + "(String key) { } in " + potentialClasses;
        this.findIntMethod = PlugBoard.lookupTarget.findFixturingMethod(evaluator, findName, intArg);
        this.findStringMethod = PlugBoard.lookupTarget.findFixturingMethod(evaluator, findName, stringArg);
        this.showMethod = PlugBoard.lookupTarget.findFixturingMethod(evaluator, showMethodName, showArg);
    }

    private Object callFindStringMethod(String text) throws Exception {
        if (this.findStringMethod != null) {
            return this.findStringMethod.invoke(new String[]{text});
        }
        if ("".equals(text)) {
            return null;
        }
        throw new FitLibraryException(this.findExceptionMessage);
    }

    public Object find(String text) throws Exception, IllegalAccessException, InvocationTargetException {
        if (this.findIntMethod != null) {
            int index = 0;
            try {
                index = this.referenceParser.getIndex(text);
            }
            catch (FitLibraryException e) {
                return this.callFindStringMethod(text);
            }
            return this.findIntMethod.invoke(new Integer[]{new Integer(index)});
        }
        return this.callFindStringMethod(text);
    }

    public String show(Object result) throws Exception {
        Object[] args = new Object[]{result};
        if (this.showMethod != null) {
            return this.showMethod.invoke(args).toString();
        }
        if (result == null) {
            return "";
        }
        return result.toString();
    }

    public boolean hasFinderMethod() {
        return this.findIntMethod != null || this.findStringMethod != null;
    }
}

