/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ParserFactory;
import fitlibrary.table.Cell;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ExtendedCamelCase;
import fitlibrary.utility.TestResults;
import fitlibraryGeneric.typed.GenericTyped;

public class EnumParser
implements Parser {
    private GenericTyped typed;
    private Evaluator evaluator;

    public EnumParser(GenericTyped typed, Evaluator evaluator) {
        this.typed = typed;
        this.evaluator = evaluator;
    }

    public TypedObject parseTyped(Cell cell, TestResults testResults) throws Exception {
        String text = cell.text(this.evaluator);
        if (text.equals("")) {
            return this.typed.typedObject(null);
        }
        Class<?> asClass = this.typed.asClass();
        try {
            return this.typed.typedObject(Enum.valueOf(asClass, ExtendedCamelCase.camel(text.replaceAll("\\s+", "")).toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            try {
                return this.typed.typedObject(Enum.valueOf(asClass, ExtendedCamelCase.camel(text.replaceAll("\\s+", "_")).toUpperCase()));
            }
            catch (IllegalArgumentException e2) {
                throw new FitLibraryException("Unknown");
            }
        }
    }

    public boolean matches(Cell cell, Object result, TestResults testResults) throws Exception {
        if (cell.hasEmbeddedTable()) {
            cell.unexpected(testResults, "collection");
            return false;
        }
        if (cell.text(this.evaluator).equals("")) {
            return result == null;
        }
        Object parsed = this.parseTyped(cell, testResults).getSubject();
        return parsed.equals(result);
    }

    public String show(Object result) throws Exception {
        return result.toString();
    }

    public static ParserFactory parserFactory() {
        return new ParserFactory(){

            public Parser parser(Evaluator evaluator, Typed typed) {
                return new EnumParser((GenericTyped)typed, evaluator);
            }
        };
    }

    public Evaluator traverse(TypedObject typedObject) {
        throw new RuntimeException("No Traverse available");
    }
}

