/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.parser.HtmlParser;
import fitlibrary.table.Cell;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.TestResults;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlStructureParser
implements HtmlParser {
    private Typed typed;

    protected HtmlStructureParser(Typed typed) {
        this.typed = typed;
    }

    protected Object callReflectively(String methodName, Object[] args, Class<?>[] argTypes, Object object) {
        try {
            Method reflectiveMethod = this.typed.asClass().getMethod(methodName, argTypes);
            return reflectiveMethod.invoke(object, args);
        }
        catch (SecurityException e) {
            this.error(methodName, argTypes, e);
        }
        catch (NoSuchMethodException e) {
            this.error(methodName, argTypes, e);
        }
        catch (IllegalArgumentException e) {
            this.error(methodName, argTypes, e);
        }
        catch (IllegalAccessException e) {
            this.error(methodName, argTypes, e);
        }
        catch (InvocationTargetException e) {
            this.error(methodName, argTypes, e.getTargetException());
        }
        return null;
    }

    private void error(String methodName, Class<?>[] argTypes, Throwable ex) {
        String args = Arrays.asList(argTypes).toString();
        args = "(" + args.substring(1, args.length() - 1) + ")";
        String problem = "Problem with accessing " + methodName + args + " of class " + this.typed.asClass().getName() + ": " + ex;
        throw new FitLibraryException(problem);
    }

    @Override
    public TypedObject parseTyped(Cell cell, TestResults testResults) throws Exception {
        return this.typed.typedObject(this.parse(cell, testResults));
    }

    protected abstract Object parse(Cell var1, TestResults var2) throws Exception;

    @Override
    public boolean matches(Cell cell, Object result, TestResults testResults) throws Exception {
        return this.areEqual(this.parseTyped(cell, testResults).getSubject(), result);
    }

    protected boolean areEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }
}

