/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.collection;

import fitlibrary.collection.array.ArraySetUpTraverse;
import fitlibrary.collection.array.ArrayTraverse;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ParserFactory;
import fitlibrary.table.Cell;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ClassUtility;
import fitlibrary.utility.TestResults;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayParser
implements Parser {
    protected final Parser componentParser;
    protected Typed componentType;
    protected final Evaluator evaluator;

    public ArrayParser(Evaluator evaluator, Typed typed) {
        this.evaluator = evaluator;
        this.componentType = typed.getComponentTyped();
        this.componentParser = this.componentType.resultParser(evaluator);
    }

    public static boolean applicableType(Class<?> type) {
        return type.isArray() && (ClassUtility.isEffectivelyPrimitive(type.getComponentType()) || type.getComponentType().isArray());
    }

    @Override
    public TypedObject parseTyped(Cell cell, TestResults testResults) throws Exception {
        return this.componentType.typedObject(this.parse(cell, testResults));
    }

    private Object parse(Cell cell, TestResults testResults) throws Exception {
        if (cell.hasEmbeddedTable()) {
            return this.parseTable(cell.getEmbeddedTable(), testResults);
        }
        return this.parse(cell.text(this.evaluator), testResults);
    }

    protected Object parseTable(Table table, TestResults testResults) {
        ArraySetUpTraverse setUp = new ArraySetUpTraverse(this.componentType.asClass(), this.componentParser);
        setUp.interpretWithinContext(table, this.evaluator, testResults);
        return setUp.getResults();
    }

    @Override
    public boolean matches(Cell cell, Object result, TestResults testResults) throws Exception {
        if (cell.hasEmbeddedTable()) {
            return this.tableMatches(cell.getEmbeddedTable(), result, testResults);
        }
        return this.equals(this.parse(cell, testResults), result, testResults);
    }

    protected boolean tableMatches(Table table, Object results, TestResults testResults) {
        if (results instanceof Object[]) {
            Object[] array = (Object[])results;
            if (array.getClass().getComponentType().isArray()) {
                ArrayTraverse nestingArray = new ArrayTraverse(array, true);
                return nestingArray.doesTablePass(table, this.evaluator, testResults);
            }
            ArrayTraverse traverse = new ArrayTraverse(array);
            return traverse.doesInnerTablePass(table, this.evaluator, testResults);
        }
        Traverse traverse = ArrayParser.selectPrimitiveArray(results);
        return traverse.doesInnerTablePass(table, this.evaluator, testResults);
    }

    public static Traverse selectPrimitiveArray(Object array) {
        if (array.getClass().isArray()) {
            if (ClassUtility.isEffectivelyPrimitive(array.getClass().getComponentType())) {
                return new ArrayTraverse(array);
            }
            if (array.getClass().getComponentType().isArray()) {
                return new ArrayTraverse(array);
            }
            List<Object> asList = Arrays.asList((Object[])array);
            return new ArrayTraverse(ArrayParser.asArray(asList));
        }
        if (array instanceof Collection) {
            return new ArrayTraverse(ArrayParser.asArray((Collection)array));
        }
        throw new FitLibraryException("Object is not an array or collection, but is of " + array.getClass());
    }

    private static String[] asArray(Collection<?> collection) {
        String[] asArray = new String[collection.size()];
        int i = 0;
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            asArray[i] = it.next().toString();
            ++i;
        }
        return asArray;
    }

    private Object parse(String s, TestResults testResults) throws Exception {
        StringTokenizer t = new StringTokenizer(s, ",");
        Object array = Array.newInstance(this.componentType.asClass(), t.countTokens());
        int i = 0;
        while (t.hasMoreTokens()) {
            Array.set(array, i, this.componentParser.parseTyped(new Cell(t.nextToken()), testResults).getSubject());
            ++i;
        }
        return array;
    }

    @Override
    public String show(Object o) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, Exception {
        if (o == null) {
            return "";
        }
        int length = Array.getLength(o);
        StringBuffer b = new StringBuffer(5 * length);
        for (int i = 0; i < length; ++i) {
            String element = this.componentParser.show(Array.get(o, i));
            b.append(element);
            if (i >= length - 1) continue;
            b.append(", ");
        }
        return b.toString();
    }

    private boolean equals(Object a, Object b, TestResults testResults) {
        int length = Array.getLength(a);
        if (length != Array.getLength(b)) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            try {
                if (this.componentParser.matches(new Cell(Array.get(a, i).toString()), Array.get(b, i), testResults)) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static ParserFactory parserFactory() {
        return new ParserFactory(){

            public Parser parser(Evaluator evaluator, Typed typed) {
                return new ArrayParser(evaluator, typed);
            }
        };
    }

    @Override
    public Evaluator traverse(TypedObject object) {
        return new ArrayTraverse(object.getSubject());
    }
}

