/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.lookup;

import fitlibrary.exception.parse.CouldNotParseException;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ParserFactory;
import fitlibrary.parser.lookup.PropertyEditorBasedParser;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupPropertyEditorBasedParser {
    static Set<Class<?>> nullables = new HashSet();

    public static ParserFactory parserFactory(final Typed typed) {
        final PropertyEditor editor = LookupPropertyEditorBasedParser.findPropertyEditor(typed.asClass());
        if (editor != null) {
            return new ParserFactory(){

                public Parser parser(Evaluator evaluator, Typed typed2) {
                    return new PropertyEditorBasedParser(evaluator, typed2, editor, nullables.contains(typed.asClass()));
                }
            };
        }
        return null;
    }

    private static PropertyEditor findPropertyEditor(Class<?> type) {
        if (type == Class.class) {
            return new ClassPropertyEditor();
        }
        if (type == Integer.class) {
            return PropertyEditorManager.findEditor(Integer.TYPE);
        }
        if (type == Character.TYPE || type == Character.class) {
            return new CharPropertyEditor();
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return new BooleanPropertyEditor();
        }
        return PropertyEditorManager.findEditor(type);
    }

    static {
        nullables.add(Byte.class);
        nullables.add(Short.class);
        nullables.add(Integer.class);
        nullables.add(Long.class);
        nullables.add(Float.class);
        nullables.add(Double.class);
        nullables.add(Date.class);
    }

    public static class DatePropertyEditor
    extends PropertyEditorSupport {
        private final DateFormat dateFormatter = DateFormat.getDateInstance(3);

        public void setAsText(String text) throws IllegalArgumentException {
            try {
                this.setValue(this.dateFormatter.parse(text));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(text);
            }
        }
    }

    public static class BooleanPropertyEditor
    extends PropertyEditorSupport {
        public void setAsText(String textInitially) throws IllegalArgumentException {
            String text = textInitially.toLowerCase();
            boolean bool = text.equals("true") || text.equals("yes") || text.equals("1") || text.equals("y") || text.equals("+");
            this.setValue(new Boolean(bool));
        }
    }

    public static class CharPropertyEditor
    extends PropertyEditorSupport {
        public void setAsText(String text) throws IllegalArgumentException {
            if ("".equals(text)) {
                this.setValue(new Character(' '));
            } else {
                this.setValue(new Character(text.charAt(0)));
            }
        }
    }

    public static class ClassPropertyEditor
    extends PropertyEditorSupport {
        public void setAsText(String text) throws IllegalArgumentException {
            try {
                this.setValue(Class.forName(text));
            }
            catch (ClassNotFoundException e) {
                throw new CouldNotParseException(Class.class, text);
            }
        }
    }
}

