/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.lookup;

import fitlibrary.object.DomainObjectParser;
import fitlibrary.parser.ByStringParser;
import fitlibrary.parser.DelegateParser;
import fitlibrary.parser.DelegatingParser;
import fitlibrary.parser.EnumParser;
import fitlibrary.parser.FailingDelegateParser;
import fitlibrary.parser.Parser;
import fitlibrary.parser.collection.ArrayParser;
import fitlibrary.parser.collection.ListParser;
import fitlibrary.parser.collection.SetParser;
import fitlibrary.parser.graphic.GraphicParser;
import fitlibrary.parser.lookup.LookupPropertyEditorBasedParser;
import fitlibrary.parser.lookup.ParseDelegation;
import fitlibrary.parser.lookup.ParserFactory;
import fitlibrary.parser.table.TableParser;
import fitlibrary.parser.tagged.TaggedStringParser;
import fitlibrary.parser.tree.TreeParser;
import fitlibrary.table.Cell;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import fitlibrary.utility.TestResults;
import fitlibraryGeneric.list.ListParser2;
import fitlibraryGeneric.map.MapParser2;
import fitlibraryGeneric.set.SetParser2;
import fitlibraryGeneric.typed.GenericTyped;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserSelectorForType {
    private Map<Class<?>, ParserFactory> mapClassToParserFactory = new ConcurrentHashMap(10000);

    public Parser parserFor(Evaluator evaluator, Typed typed, boolean isResult) {
        Class<?> classType = typed.asClass();
        DelegateParser delegate = ParseDelegation.getDelegate(classType);
        if (delegate != null) {
            return delegate.parser(evaluator, typed);
        }
        DomainObjectParser domainObjectParser = new DomainObjectParser(evaluator, typed);
        if (domainObjectParser.hasFinderMethod()) {
            return domainObjectParser;
        }
        ParserFactory parserFactory = this.mapClassToParserFactory.get(classType);
        if (parserFactory == null) {
            parserFactory = this.parserFactory(typed, isResult);
            if (parserFactory != null) {
                this.mapClassToParserFactory.put(classType, parserFactory);
            } else {
                if (classType != String.class && classType != Object.class) {
                    return domainObjectParser;
                }
                return new DelegatingParser(new FailingDelegateParser(typed.asClass()), evaluator, typed);
            }
        }
        return parserFactory.parser(evaluator, typed);
    }

    private ParserFactory parserFactory(Typed typed, boolean isResult) {
        Class<?> classType = typed.asClass();
        if (Map.class.isAssignableFrom(classType)) {
            return this.mapParserFactory();
        }
        if (SetParser.applicableType(classType)) {
            return this.setParserFactory();
        }
        if (ArrayParser.applicableType(classType)) {
            return ArrayParser.parserFactory();
        }
        if (ListParser.applicableType(classType)) {
            return this.listParserFactory();
        }
        if (TreeParser.applicableType(classType)) {
            return TreeParser.parserFactory();
        }
        if (TableParser.applicableType(classType)) {
            return TableParser.parserFactory();
        }
        if (GraphicParser.applicableType(classType)) {
            return GraphicParser.parserFactory();
        }
        if (TaggedStringParser.applicableType(classType)) {
            return TaggedStringParser.parserFactory();
        }
        ParserFactory factory = LookupPropertyEditorBasedParser.parserFactory(typed);
        if (factory != null) {
            return factory;
        }
        factory = ParseDelegation.selfParseFactory(typed);
        if (factory != null) {
            return factory;
        }
        if (typed.isEnum()) {
            return EnumParser.parserFactory();
        }
        if (this.canTreatAsString(classType, typed.hasMethodOrField(), isResult)) {
            return ByStringParser.parserFactory();
        }
        return null;
    }

    protected ParserFactory listParserFactory() {
        return ListParser2.parserFactory();
    }

    protected ParserFactory setParserFactory() {
        return SetParser2.parserFactory();
    }

    protected ParserFactory mapParserFactory() {
        return MapParser2.parserFactory();
    }

    private boolean canTreatAsString(Class<?> type, boolean hasCaller, boolean isResult) {
        return isResult && hasCaller && type == Object.class;
    }

    public static Object evaluate(Evaluator evaluator, Type type, String text) throws Exception {
        Parser parserFor = new ParserSelectorForType().parserFor(evaluator, new GenericTyped(type), false);
        TestResults testResults = new TestResults();
        Cell cell = new Cell(text);
        Object subject = parserFor.parseTyped(cell, testResults).getSubject();
        if (testResults.problems()) {
            throw new RuntimeException("Unable to parse '" + text + "' as a " + type + ": " + cell.fullText());
        }
        return subject;
    }
}

