/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.self;

import fitlibrary.parser.DelegateParser;
import fitlibrary.typed.Typed;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelfConstructorParser
extends DelegateParser
implements Cloneable {
    private Constructor<?> constructor;

    public static SelfConstructorParser findSelfConstructorParser(Class<?> type) {
        Constructor<?> constructor = SelfConstructorParser.findConstructor(type);
        if (constructor == null) {
            return null;
        }
        return new SelfConstructorParser(constructor);
    }

    public SelfConstructorParser(Constructor<?> parseMethod) {
        this.constructor = parseMethod;
    }

    public static Constructor<?> findConstructor(Class<?> type) {
        Constructor<?>[] declaredConstructors;
        if (Modifier.isAbstract(type.getModifiers())) {
            return null;
        }
        for (Constructor<?> constructor : declaredConstructors = type.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != String.class) continue;
            return constructor;
        }
        return null;
    }

    @Override
    public Object parse(String s, Typed typed) throws Exception {
        this.constructor.setAccessible(true);
        return this.constructor.newInstance(s);
    }
}

