/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runner;

import fit.Counts;
import fit.Parse;
import fitlibrary.runner.CustomRunner;
import fitlibrary.runner.CustomRunnerException;
import fitlibrary.runner.Report;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.table.Tables;
import fitlibrary.utility.TestResults;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SpreadsheetRunner {
    private boolean tableStarted = false;
    private Report report = null;

    public SpreadsheetRunner(Report report) {
        this.report = report;
    }

    public SpreadsheetRunner() {
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        new SpreadsheetRunner().run(new File("test.xls"), new File("report.html"), new BatchFitLibrary());
    }

    public Counts run(File inFile, File reportFile, BatchFitLibrary fitLibraryServer) throws FileNotFoundException, IOException {
        return this.run(inFile, reportFile, new Parse("table", "", null, null), null, fitLibraryServer);
    }

    public Counts run(File inFile, File reportFile, Parse setUpTables, Parse tearDownTables, BatchFitLibrary batchFitLibrary) throws FileNotFoundException, IOException {
        PrintWriter output = new PrintWriter(new OutputStreamWriter(new FileOutputStream(reportFile)));
        try {
            CustomRunner customRunner = this.collect(inFile, reportFile, setUpTables, tearDownTables);
            if (this.report != null) {
                Parse parse = customRunner.getTables();
                parse.leader = this.report.addLinks(parse.leader, inFile);
            }
            Parse tables = customRunner.getTables();
            TestResults testResults = batchFitLibrary.doStorytest(new Tables(tables));
            tables.print(output);
            output.close();
            return testResults.getCounts();
        }
        catch (CustomRunnerException e) {
            throw new RuntimeException(e.getMessage() + " in file " + inFile.getAbsolutePath());
        }
    }

    public Parse collectTable(File setUpFile) throws FileNotFoundException, IOException, CustomRunnerException {
        CustomRunner runner = this.collect(setUpFile, null, null, null);
        return runner.getTables();
    }

    private CustomRunner collect(File inFile, File reportFile, Parse setUpTables, Parse tearDownTables) throws IOException, FileNotFoundException {
        CustomRunner runner = new CustomRunner(inFile.getName(), inFile, reportFile);
        if (setUpTables != null) {
            runner.addTables(setUpTables);
        }
        FileInputStream fileInputStream = new FileInputStream(inFile);
        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)fileInputStream);
        String preText = this.collectTables(runner, workbook);
        fileInputStream.close();
        if (tearDownTables != null) {
            tearDownTables.leader = tearDownTables.leader + preText;
            runner.addTables(tearDownTables);
        } else if (!preText.equals("")) {
            runner.addTableTrailer(preText);
        }
        return runner;
    }

    private String collectTables(CustomRunner runner, HSSFWorkbook workbook) {
        HSSFSheet sheet = workbook.getSheetAt(0);
        String preText = "";
        Iterator it = sheet.rowIterator();
        while (it.hasNext()) {
            HSSFRow row = (HSSFRow)it.next();
            HSSFCell[] cells = this.getCells(row);
            String[] borderedCellValues = this.getBorderedCellValues(cells, workbook);
            if (borderedCellValues.length > 0) {
                this.addRow(runner, borderedCellValues, preText);
                preText = "";
                continue;
            }
            String text = this.allText(cells, workbook) + "\n";
            if (preText.equals("") && !text.equals("")) {
                preText = text;
                continue;
            }
            preText = preText + "<BR>" + text;
        }
        return preText;
    }

    public void addRow(CustomRunner runner, String[] cells, String preText) {
        if (this.tableStarted && preText.equals("")) {
            runner.addRow(cells);
        } else {
            runner.addTable(cells, preText);
            this.tableStarted = true;
        }
    }

    private String allText(HSSFCell[] cells, HSSFWorkbook workbook) {
        String result = this.format(cells[0], workbook);
        for (int i = 1; i < cells.length; ++i) {
            String value = this.format(cells[i], workbook);
            if (value.equals("")) continue;
            result = result + " " + value;
        }
        return result;
    }

    private String[] getBorderedCellValues(HSSFCell[] cells, HSSFWorkbook workbook) {
        HSSFCell cell;
        ArrayList<String> list = new ArrayList<String>();
        int cellNo = 0;
        while (cellNo < cells.length) {
            if (!this.leftBordered(cell = cells[cellNo++])) continue;
            list.add(this.format(cell, workbook));
            break;
        }
        while (cellNo < cells.length) {
            if (!this.leftBordered(cell = cells[cellNo++])) continue;
            list.add(this.format(cell, workbook));
        }
        String[] result = new String[list.size()];
        int i = 0;
        for (String it : list) {
            result[i++] = it;
        }
        return result;
    }

    private boolean leftBordered(HSSFCell cell) {
        if (cell == null) {
            return false;
        }
        return cell.getCellStyle().getBorderLeft() > 0;
    }

    private HSSFCell[] getCells(HSSFRow row) {
        short maxCell = row.getLastCellNum();
        HSSFCell[] cells = new HSSFCell[maxCell];
        for (int i = 0; i < cells.length; ++i) {
            cells[i] = null;
        }
        Iterator r = row.cellIterator();
        while (r.hasNext()) {
            HSSFCell cell = (HSSFCell)r.next();
            short cellNo = cell.getCellNum();
            cells[cellNo] = cell;
        }
        return cells;
    }

    private String format(HSSFCell cell, HSSFWorkbook workbook) {
        if (cell == null) {
            return "";
        }
        String value = this.value(cell);
        HSSFCellStyle style = cell.getCellStyle();
        HSSFFont font = workbook.getFontAt(style.getFontIndex());
        if (font.getItalic()) {
            value = this.tag("i", value);
        }
        if (font.getBoldweight() > 400) {
            value = this.tag("b", value);
        }
        if (font.getUnderline() > 0) {
            value = this.tag("u", value);
        }
        if (font.getFontHeight() >= 480) {
            value = this.tag("h1", value);
        } else if (font.getFontHeight() >= 280) {
            value = this.tag("h2", value);
        } else if (font.getFontHeight() > 200) {
            value = this.tag("h3", value);
        }
        return value;
    }

    private String tag(String tag, String string) {
        return "<" + tag + ">" + string + "</" + tag + ">";
    }

    private String value(HSSFCell cell) {
        switch (cell.getCellType()) {
            case 3: {
                return "";
            }
            case 4: {
                return "" + cell.getBooleanCellValue();
            }
            case 5: {
                return "ERROR";
            }
            case 2: {
                if (Double.isNaN(cell.getNumericCellValue())) {
                    try {
                        return "" + cell.getBooleanCellValue();
                    }
                    catch (NumberFormatException ex) {
                        return cell.getStringCellValue();
                    }
                }
                return this.number(cell);
            }
            case 0: {
                return this.number(cell);
            }
            case 1: {
                return cell.getStringCellValue();
            }
        }
        return "UNKNOWN";
    }

    private String number(HSSFCell cell) {
        double value = cell.getNumericCellValue();
        if ((double)((int)value) == value) {
            return "" + (int)value;
        }
        return "" + value;
    }
}

