/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runtime;

import fitlibrary.dynamicVariable.DynamicVariables;
import fitlibrary.dynamicVariable.GlobalDynamicVariables;
import fitlibrary.dynamicVariable.LocalDynamicVariables;
import fitlibrary.log.FileLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RuntimeContext {
    private DynamicVariables dynamicVariables = new GlobalDynamicVariables();
    private Map<String, Integer> timeouts = new HashMap<String, Integer>();
    private FileLogger fileLogger = new FileLogger();

    public RuntimeContext() {
    }

    public RuntimeContext(String[] s) {
        for (int i = 0; i < s.length - 1; i += 2) {
            this.dynamicVariables.put(s[i], s[i + 1]);
        }
    }

    public RuntimeContext(DynamicVariables dynamicVariables) {
        this.dynamicVariables = dynamicVariables;
    }

    public RuntimeContext freshCopy() {
        return new RuntimeContext(new GlobalDynamicVariables(this.dynamicVariables.top()));
    }

    public DynamicVariables dynamicVariables() {
        return this.dynamicVariables;
    }

    public String toString() {
        return this.dynamicVariables().toString();
    }

    public void putTimeout(String name, int timeout) {
        this.timeouts.put(name, timeout);
    }

    public int getTimeout(String name, int defaultTimeout) {
        Integer timeout = this.timeouts.get(name);
        if (timeout == null) {
            return defaultTimeout;
        }
        return timeout;
    }

    public void startLogging(String fileName) {
        this.fileLogger.start(fileName);
    }

    public void printToLog(String s) throws IOException {
        this.fileLogger.println(s);
    }

    public void pushLocal() {
        this.dynamicVariables = new LocalDynamicVariables(this.dynamicVariables);
    }

    public void popLocal() {
        this.dynamicVariables = this.dynamicVariables.popLocal();
    }
}

