/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.suite;

import fit.Counts;
import fit.FixtureBridge;
import fitlibrary.dynamicVariable.RecordDynamicVariables;
import fitlibrary.parser.lookup.ParseDelegation;
import fitlibrary.suite.IndependentSuiteRunner;
import fitlibrary.suite.IntegratedSuiteRunner;
import fitlibrary.suite.Reportage;
import fitlibrary.suite.SuiteEvaluator;
import fitlibrary.suite.SuiteRunner;
import fitlibrary.table.ParseNode;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;
import java.io.IOException;

public class BatchFitLibrary {
    private boolean first = true;
    private SuiteRunner suiteRunner = new IndependentSuiteRunner(null);
    private TableListener tableListener = new TableListener(TestResults.create(new Counts()));
    private Reportage reportage;

    public BatchFitLibrary() {
        this(new DefaultReportage());
    }

    public BatchFitLibrary(Reportage reportage) {
        this.reportage = reportage;
    }

    public BatchFitLibrary(TableListener tableListener) {
        this.tableListener = tableListener;
    }

    public TestResults doStorytest(Tables theTables) {
        ParseDelegation.clearDelegatesForNextStorytest();
        return this.doTables(theTables);
    }

    public TestResults doTables(Tables theTables) {
        this.tableListener.clearTestResults();
        if (this.first) {
            this.first = false;
            FixtureBridge fixtureBridge = new FixtureBridge();
            fixtureBridge.counts = this.tableListener.getTestResults().getCounts();
            Object firstObjectOfSuite = fixtureBridge.firstObject(theTables.parse(), this.tableListener.getTestResults());
            if (firstObjectOfSuite == null) {
                theTables.ignoreAndFinished(this.tableListener);
                return this.tableListener.getTestResults();
            }
            if (firstObjectOfSuite instanceof SuiteEvaluator) {
                this.suiteRunner = new IntegratedSuiteRunner((SuiteEvaluator)firstObjectOfSuite);
                this.reportage.showAllReports();
            } else {
                this.suiteRunner = new IndependentSuiteRunner(firstObjectOfSuite);
            }
            this.suiteRunner.runFirstStorytest(theTables, this.tableListener);
        } else {
            this.suiteRunner.runStorytest(theTables, this.tableListener);
        }
        if (RecordDynamicVariables.recording()) {
            try {
                RecordDynamicVariables.write();
            }
            catch (IOException e) {
                Table errorTable = new Table(new Row("note", ParseNode.label("Problem on writing property file:") + "<hr/>" + e.getMessage()));
                errorTable.row(0).cell(1).error(this.tableListener.getTestResults());
                theTables.add(errorTable);
            }
        }
        return this.tableListener.getTestResults();
    }

    public void doTables(Tables theTables, TableListener listener) {
        this.tableListener = listener;
        this.doStorytest(theTables);
    }

    public void exit() {
        if (this.suiteRunner != null) {
            this.suiteRunner.exit();
        }
    }

    public static class DefaultReportage
    implements Reportage {
        public void showAllReports() {
        }
    }
}

