/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.suite;

import fit.FitServerBridge;
import fit.Parse;
import fit.exception.FitParseException;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.suite.Reportage;
import fitlibrary.table.Tables;
import fitlibrary.utility.ParseUtility;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;
import java.util.Date;

public class FitLibraryServer
extends FitServerBridge
implements Reportage {
    private BatchFitLibrary batching = new BatchFitLibrary(this);

    public FitLibraryServer(String host, int port, boolean verbose) {
        super(host, port, verbose);
    }

    public FitLibraryServer() {
    }

    public void doTables(String html) {
        try {
            String translated = ParseUtility.tabulize(html);
            this.fixture.counts = this.doTables(new Tables(new Parse(translated))).getCounts();
        }
        catch (FitParseException e) {
            e.printStackTrace();
        }
    }

    public TestResults doTables(Tables theTables) {
        TableListener tableListener = new TableListener(this.fixtureListener);
        this.batching.doTables(theTables, tableListener);
        return tableListener.getTestResults();
    }

    public void exit() throws Exception {
        this.batching.exit();
        super.exit();
    }

    protected void usage() {
        this.print("usage: java fit.FitLibraryServer [-v] host port socketTicket");
        System.exit(-1);
    }

    public static void main(String[] args) {
        FitLibraryServer fitServer = new FitLibraryServer();
        try {
            fitServer.print("\n-----------\n" + new Date() + "\n");
            fitServer.run(args);
            fitServer.print("exit: " + fitServer.exitCode());
            if (fitServer.isExit()) {
                System.exit(fitServer.exitCode());
            }
        }
        catch (Exception e) {
            fitServer.printExceptionDetails(e);
        }
    }
}

