/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.suite;

import fit.FitServerBridge;
import fit.FixtureBridge;
import fitlibrary.DomainFixture;
import fitlibrary.suite.InFlowPageRunner;
import fitlibrary.suite.OutOfFlowPageRunner;
import fitlibrary.suite.SuiteRunner;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.AlienTraverseHandler;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.traverse.workflow.DoEvaluator;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;

public class IndependentSuiteRunner
implements SuiteRunner {
    private static final AlienTraverseHandler alienTraverseHandler = Traverse.getAlienTraverseHandler();
    private Object firstObjectOfFirstStorytest;

    public IndependentSuiteRunner(Object firstObjectOfFirstStorytest) {
        this.firstObjectOfFirstStorytest = firstObjectOfFirstStorytest;
    }

    public void runFirstStorytest(Tables tables, TableListener tableListener) {
        this.runEachStorytest(this.firstObjectOfFirstStorytest, tables, tableListener);
    }

    public void runStorytest(Tables tables, TableListener tableListener) {
        Object firstObject = new FixtureBridge().firstObject(tables.parse(), tableListener.getTestResults());
        this.runEachStorytest(firstObject, tables, tableListener);
    }

    private void runEachStorytest(Object objectInitial, Tables tables, TableListener tableListener) {
        Object object = objectInitial;
        TestResults testResults = tableListener.getTestResults();
        if (object == null || testResults.isAbandoned()) {
            tables.ignoreAndFinished(tableListener);
            return;
        }
        if (!this.evaluator(object)) {
            object = new DomainFixture(object);
        }
        if (object instanceof DoEvaluator) {
            DoEvaluator doEvaluator = (DoEvaluator)object;
            doEvaluator.setDynamicVariable("fitNesse.url", FitServerBridge.FITNESSE_URL);
            Table firstTable = tables.table(0);
            doEvaluator.setUp(firstTable, testResults);
            doEvaluator.interpretAfterFirstRow(firstTable, testResults);
            tableListener.tableFinished(firstTable);
            new InFlowPageRunner(doEvaluator, testResults).run(tables, 1, tableListener, true);
        } else {
            new OutOfFlowPageRunner(object, tables, tableListener);
        }
        tableListener.storytestFinished();
    }

    private boolean evaluator(Object object) {
        return alienTraverseHandler.isAlienTraverse(object) || object instanceof Evaluator;
    }

    public void exit() {
    }
}

