/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.suite;

import fit.FitServerBridge;
import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.suite.InFlowPageRunner;
import fitlibrary.suite.SuiteEvaluator;
import fitlibrary.suite.SuiteRunner;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.workflow.DoEvaluator;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;
import fitlibraryGeneric.typed.GenericTypedFactory;

public class IntegratedSuiteRunner
implements SuiteRunner {
    private SuiteEvaluator suiteEvaluator;
    protected boolean abandoned = false;

    public IntegratedSuiteRunner(SuiteEvaluator suiteEvaluator) {
        this.suiteEvaluator = suiteEvaluator;
        suiteEvaluator.setDynamicVariable("fitNesse.url", FitServerBridge.FITNESSE_URL);
    }

    public void runFirstStorytest(Tables tables, TableListener tableListener) {
        TestResults testResults = tableListener.getTestResults();
        Table firstTable = tables.table(0);
        this.suiteMethod("suiteSetUp", firstTable, tableListener.getTestResults());
        this.suiteEvaluator.setUp(firstTable, testResults);
        this.suiteEvaluator.interpretAfterFirstRow(firstTable, testResults);
        tableListener.tableFinished(firstTable);
        this.runEachStorytest(tables, 1, tableListener);
    }

    private void suiteMethod(String methodName, Table firstTable, TestResults results) {
        try {
            CalledMethodTarget methodTarget = new GenericTypedFactory().asTypedObject(this.suiteEvaluator).optionallyFindMethodOnTypedObject(methodName, 0, this.suiteEvaluator, false);
            if (methodTarget != null) {
                methodTarget.invoke();
            }
        }
        catch (Exception e) {
            firstTable.error(results, (Throwable)e);
        }
    }

    public void runStorytest(Tables tables, TableListener tableListener) {
        this.runEachStorytest(tables, 0, tableListener);
    }

    private void runEachStorytest(Tables tables, int fromTable, TableListener tableListener) {
        TestResults testResults = tableListener.getTestResults();
        testResults.setSuiteFixtureSoDoNotTearDown(true);
        for (int i = fromTable; i < tables.size(); ++i) {
            Table table = tables.table(i);
            if (testResults.isAbandoned()) {
                tableListener.tableFinished(table);
                continue;
            }
            Object result = this.suiteEvaluator.interpretWholeTable(table, tableListener);
            tableListener.tableFinished(table);
            if (this.abandoned) {
                table.ignore(testResults);
            }
            if (!(result instanceof DoEvaluator)) continue;
            testResults.setSuiteFixtureSoDoNotTearDown(false);
            DoEvaluator doEvaluator = (DoEvaluator)result;
            doEvaluator.setRuntimeContext(this.suiteEvaluator.getCopyOfDynamicVariables());
            doEvaluator.setUp(table, testResults);
            new InFlowPageRunner(doEvaluator, testResults).run(tables, i + 1, tableListener, true);
            break;
        }
        tableListener.storytestFinished();
    }

    public void exit() {
        Row row = new Row();
        row.addCell();
        this.suiteMethod("suiteTearDown", new Table(row), new TestResults());
    }
}

