/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.suite;

import fit.FitServerBridge;
import fit.Fixture;
import fit.FixtureBridge;
import fitlibrary.suite.InFlowPageRunner;
import fitlibrary.suite.PageRunner;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.workflow.DoEvaluator;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class OutOfFlowPageRunner
extends PageRunner {
    FixtureBridge bridge = new FixtureBridge();
    Map<String, Object> summary = new HashMap<String, Object>();

    public OutOfFlowPageRunner(Object fixtureLikeObject, Tables tables, TableListener tableListener) {
        super(tableListener.getTestResults());
        this.summary.put("run date", new Date());
        this.summary.put("run elapsed time", new Fixture().new Fixture.RunTime());
        Table table = tables.table(0);
        TestResults testResults = tableListener.getTestResults();
        if (fixtureLikeObject instanceof Fixture) {
            Fixture fixture = (Fixture)fixtureLikeObject;
            fixture.summary = this.summary;
            fixture.listener = tableListener.getListener();
            fixture.counts = tableListener.getTestResults().getCounts();
            try {
                fixture.doTable(table.parse);
            }
            catch (Exception e1) {
                tables.table(0).error(tableListener, e1);
            }
        } else {
            Evaluator evaluator = (Evaluator)fixtureLikeObject;
            this.interpret(evaluator, table, testResults);
            evaluator.tearDown(table, testResults);
        }
        tableListener.tableFinished(tables.table(0));
        for (int t = 1; t < tables.size() && !this.ignored(tables, t, tableListener); ++t) {
            table = tables.table(t);
            Object object = this.bridge.getFixture(table, testResults);
            if (object instanceof DoEvaluator) {
                DoEvaluator doEvaluator = (DoEvaluator)object;
                this.interpret(doEvaluator, table, testResults);
                tableListener.tableFinished(table);
                new InFlowPageRunner(doEvaluator, testResults).run(tables, t + 1, tableListener, true);
                return;
            }
            if (object instanceof Evaluator) {
                Evaluator evaluator = (Evaluator)object;
                this.interpret(evaluator, table, testResults);
                evaluator.tearDown(table, testResults);
            } else if (object instanceof Fixture) {
                try {
                    Fixture fix = (Fixture)object;
                    fix.listener = tableListener.getListener();
                    fix.counts = tableListener.getTestResults().getCounts();
                    fix.summary = this.summary;
                    fix.doTable(table.parse);
                }
                catch (Exception e) {
                    table.error(tableListener, e);
                }
            }
            tableListener.tableFinished(table);
        }
    }

    private void interpret(Evaluator evaluator, Table table, TestResults testResults) {
        evaluator.setDynamicVariable("fitNesse.url", FitServerBridge.FITNESSE_URL);
        evaluator.setUp(table, testResults);
        evaluator.interpretAfterFirstRow(table, testResults);
    }
}

