/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fit.Fixture;
import fit.Parse;
import fitlibrary.exception.table.NestedTableExpectedException;
import fitlibrary.exception.table.SingleNestedTableExpected;
import fitlibrary.global.PlugBoard;
import fitlibrary.table.ParseNode;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Evaluator;
import fitlibrary.utility.ExtendedCamelCase;
import fitlibrary.utility.HtmlUtils;
import fitlibrary.utility.ParseUtility;
import fitlibrary.utility.TestResults;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Cell
extends ParseNode {
    static final Pattern COLSPAN_PATTERN = Pattern.compile(".*\\b(colspan\\s*=\\s*\"?\\s*(\\d+)\\s*\"?).*");
    private boolean cellIsInHiddenRow = false;

    public Cell(Parse parse) {
        super(parse);
    }

    public Cell() {
        this("");
    }

    public Cell(String cellText) {
        this(new Parse("td", cellText, null, null));
    }

    public Cell(String cellText, int cols) {
        this(new Parse("td", cellText, null, null));
        this.setColumnSpan(cols);
    }

    public Cell(Tables innerTables) {
        this(new Parse("td", "", innerTables.parse, null));
    }

    public Cell(String preamble, Tables innerTables) {
        this(innerTables);
        this.parse.parts.leader = Fixture.label(preamble) + this.parse.parts.leader;
        this.calls();
    }

    public Cell(Table innerTable) {
        this(new Tables(innerTable));
    }

    public Cell(Cell cell) {
        this();
        if (cell.hasEmbeddedTable()) {
            this.setInnerTables(cell.getEmbeddedTables());
        } else {
            this.setText(cell.fullText());
        }
    }

    public String text(Evaluator evaluator) {
        String resolve;
        if (this.parse.body == null) {
            return "";
        }
        if (evaluator == null) {
            return this.parse.text();
        }
        String text = this.parse.text();
        if (!text.equals(resolve = evaluator.runtime().dynamicVariables().resolve(text))) {
            this.parse.body = resolve;
        }
        return resolve;
    }

    public String text() {
        if (this.parse.body == null) {
            return "";
        }
        return this.parse.text();
    }

    public boolean unresolved(Evaluator evaluator) {
        return this.text().startsWith("@{") && this.text().indexOf("}") == this.text().length() - 1 && this.text().equals(this.text(evaluator));
    }

    public String camelledText(Evaluator evaluator) {
        return ExtendedCamelCase.camel(this.text(evaluator));
    }

    public String textLower(Evaluator evaluator) {
        return this.text(evaluator).toLowerCase();
    }

    public boolean matchesText(String text, Evaluator evaluator) {
        return this.text(evaluator).toLowerCase().equals(text.toLowerCase());
    }

    public boolean isBlank(Evaluator evaluator) {
        return this.text(evaluator).equals("");
    }

    public boolean hasEmbeddedTable() {
        return this.parse.parts != null;
    }

    public Tables innerTables() {
        if (!this.hasEmbeddedTable()) {
            throw new NestedTableExpectedException();
        }
        return new Tables(this.parse.parts);
    }

    public Cell copy() {
        return new Cell(ParseUtility.copyParse(this.parse));
    }

    public boolean equals(Object object) {
        if (!(object instanceof Cell)) {
            return false;
        }
        Cell other = (Cell)object;
        return this.parse.body.equals(other.parse.body);
    }

    public int hashCode() {
        return this.parse.body.hashCode();
    }

    public void expectedElementMissing(TestResults testResults) {
        this.fail(testResults);
        this.addToBody(Cell.label("missing"));
    }

    public void actualElementMissing(TestResults testResults) {
        this.fail(testResults);
        this.addToBody(Cell.label("surplus"));
    }

    public void unexpected(TestResults testResults, String s) {
        this.fail(testResults);
        this.addToBody(Cell.label("unexpected " + s));
    }

    public void actualElementMissing(TestResults testResults, String value) {
        this.fail(testResults);
        this.parse.body = Fixture.gray(Fixture.escape(value.toString()));
        this.addToBody(Cell.label("surplus"));
    }

    public void pass(TestResults testResults) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.pass(testResults);
    }

    public void pass(TestResults testResults, String msg) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.pass(testResults);
        this.addToBody("<hr>" + Fixture.escape(msg) + Cell.label("actual"));
    }

    public void fail(TestResults testResults) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.fail(testResults);
    }

    public void fail(TestResults testResults, String msg, Evaluator evaluator) {
        if ("".equals(this.parse.body) && !this.hasEmbeddedTable()) {
            this.failHtml(testResults, msg);
            return;
        }
        this.fail(testResults);
        String resolved = "";
        if (!this.text().equals(this.text(evaluator))) {
            resolved = " = " + this.text(evaluator);
        }
        this.addToBody(resolved + Cell.label("expected") + "<hr>" + Fixture.escape(msg) + Cell.label("actual"));
    }

    public void failWithStringEquals(TestResults testResults, String actual, Evaluator evaluator) {
        if ("".equals(this.parse.body) && !this.hasEmbeddedTable()) {
            this.failHtml(testResults, actual);
            return;
        }
        this.fail(testResults);
        String resolved = "";
        if (!this.text().equals(this.text(evaluator))) {
            resolved = " = " + this.text(evaluator);
        }
        this.addToBody(resolved + Cell.label("expected") + "<hr>" + Fixture.escape(actual) + Cell.label("actual") + Cell.differences(Fixture.escape(this.text(evaluator)), Fixture.escape(actual)));
    }

    public static String differences(String actual, String expected) {
        return PlugBoard.stringDifferencing.differences(actual, expected);
    }

    public void fail(TestResults testResults, String msg) {
        if ("".equals(this.parse.body) && !this.hasEmbeddedTable()) {
            this.failHtml(testResults, msg);
            return;
        }
        this.fail(testResults);
        this.addToBody(Cell.label("expected") + "<hr>" + Fixture.escape(msg) + Cell.label("actual"));
    }

    public void failHtml(TestResults testResults, String msg) {
        this.fail(testResults);
        this.addToBody(msg);
    }

    public void error(TestResults testResults, Throwable e) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        this.addToBody(PlugBoard.exceptionHandling.exceptionMessage(e));
        this.parse.addToTag(" class=\"error\"");
        testResults.exception();
    }

    public void error(TestResults testResults, String msg) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        this.addToBody("<hr/>" + Fixture.label(msg));
        this.parse.addToTag(" class=\"error\"");
        testResults.exception();
    }

    public void error(TestResults testResults) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        this.parse.addToTag(" class=\"error\"");
        testResults.exception();
    }

    public void ignore(TestResults testResults) {
        if (this.parse.tag.contains(" bgcolor=#DADAFF")) {
            return;
        }
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        this.ensureBodyNotNull();
        if (this.parse.tag.indexOf("class") >= 0) {
            throw new RuntimeException("Duplicate cell class in tag. Tag is already: " + this.parse.tag.substring(1, this.parse.tag.length() - 2));
        }
        this.parse.addToTag(" class=\"ignore\"");
        testResults.ignore();
    }

    public void exceptionMayBeExpected(boolean exceptionExpected, Exception e, TestResults testResults) {
        if (exceptionExpected) {
            this.pass(testResults);
        } else {
            this.error(testResults, e);
        }
    }

    public Table getEmbeddedTable() {
        Tables tables = this.getEmbeddedTables();
        if (tables.size() != 1) {
            throw new SingleNestedTableExpected();
        }
        return tables.table(0);
    }

    public Tables getEmbeddedTables() {
        if (!this.hasEmbeddedTable()) {
            throw new NestedTableExpectedException();
        }
        return new Tables(this.parse.parts);
    }

    public String toString() {
        if (this.hasEmbeddedTable()) {
            return "Cell[" + ParseUtility.toString(this.parse.parts) + "]";
        }
        return "Cell[" + this.text() + "]";
    }

    public void wrongHtml(TestResults counts, String actual) {
        this.fail(counts);
        this.addToBody(Cell.label("expected") + "<hr>" + actual + Cell.label("actual"));
    }

    private void addToBody(String msg) {
        if (this.hasEmbeddedTable()) {
            if (this.parse.parts.more == null) {
                this.parse.parts.trailer = msg;
            } else {
                this.parse.parts.more.leader = this.parse.parts.more.leader + msg;
            }
        } else {
            this.ensureBodyNotNull();
            this.parse.addToBody(msg);
        }
    }

    public void setText(String text) {
        this.parse.body = text;
    }

    public void setEscapedText(String text) {
        this.setText(Fixture.escape(text));
    }

    public void setMultilineEscapedText(String text) {
        this.setText(HtmlUtils.escape(text));
    }

    public String fullText() {
        return this.parse.body;
    }

    public void setUnvisitedEscapedText(String s) {
        this.setUnvisitedText(Fixture.escape(s));
    }

    public void setUnvisitedMultilineEscapedText(String s) {
        this.setUnvisitedText(HtmlUtils.escape(s));
    }

    public void setUnvisitedText(String s) {
        this.setText(Fixture.gray(s));
    }

    public void passIfBlank(TestResults counts, Evaluator evaluator) {
        if (this.isBlank(evaluator)) {
            this.pass(counts);
        } else {
            this.fail(counts, "", evaluator);
        }
    }

    public void passIfNotEmbedded(TestResults counts) {
        if (!this.hasEmbeddedTable()) {
            this.pass(counts);
        }
    }

    public void setIsHidden() {
        this.cellIsInHiddenRow = true;
    }

    public void setInnerTables(Tables tables) {
        this.parse.parts = tables.parse();
    }

    public int getColumnSpan() {
        Matcher matcher = COLSPAN_PATTERN.matcher(this.parse.tag);
        int colspan = 1;
        if (matcher.matches()) {
            colspan = Integer.parseInt(matcher.group(2));
        }
        return colspan;
    }

    public void setColumnSpan(int colspan) {
        if (colspan < 1) {
            return;
        }
        Matcher matcher = COLSPAN_PATTERN.matcher(this.parse.tag);
        if (matcher.matches()) {
            this.parse.tag = this.parse.tag.replace(matcher.group(1), Cell.getColspanHtml(colspan));
        } else {
            this.parse.addToTag(Cell.getColspanHtml(colspan));
        }
    }

    private static String getColspanHtml(int colspan) {
        return " colspan=\"" + colspan + "\"";
    }
}

