/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fit.Fixture;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.IgnoredException;
import fitlibrary.table.ExceptionHandling;
import fitlibrary.traverse.Traverse;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;

public class ExceptionHandlingStandard
implements ExceptionHandling {
    public void mustBeThreadSafe() {
    }

    public String exceptionMessage(Throwable throwable) {
        Throwable exception = this.unwrapThrowable(throwable);
        if (exception instanceof IgnoredException) {
            return "";
        }
        if (exception instanceof FitLibraryException) {
            return "<hr/>" + Fixture.label(Traverse.escapeHtml(exception.getMessage()));
        }
        StringWriter buf = new StringWriter();
        exception.printStackTrace(new PrintWriter(buf));
        return "<hr><pre><div class=\"fit_stacktrace\">" + buf.toString() + "</div></pre>";
    }

    public Throwable unwrapThrowable(Throwable throwable) {
        Throwable exception = throwable;
        while (true) {
            if (exception.getCause() != null) {
                exception = exception.getCause();
                continue;
            }
            if (!exception.getClass().equals(InvocationTargetException.class)) break;
            exception = ((InvocationTargetException)exception).getTargetException();
        }
        return exception;
    }
}

