/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fit.Parse;
import fitlibrary.utility.TestResults;

public abstract class ParseNode {
    public static final String PASS = " class=\"pass\"";
    public static final String FAIL = " class=\"fail\"";
    public static final String IGNORE = " class=\"ignore\"";
    public static final String ERROR = " class=\"error\"";
    public static final String SHOWN = " bgcolor=#C0C0FF";
    public static final String CALLS = " bgcolor=#DADAFF";
    public Parse parse;

    public ParseNode(Parse parse) {
        this.parse = parse;
    }

    public void pass(TestResults testResults) {
        this.ensureBodyNotNull();
        this.parse.addToTag(PASS);
        testResults.pass();
    }

    public void fail(TestResults testResults) {
        this.ensureBodyNotNull();
        if (!this.hadError()) {
            this.parse.addToTag(FAIL);
            testResults.fail();
        }
    }

    public void passOrFail(TestResults testResults, boolean right) {
        if (right) {
            this.pass(testResults);
        } else {
            this.fail(testResults);
        }
    }

    public void shown() {
        this.ensureBodyNotNull();
        this.parse.addToTag(SHOWN);
    }

    public void calls() {
        this.ensureBodyNotNull();
        this.parse.addToTag(CALLS);
    }

    public static String label(String string) {
        return " <span class=\"fit_label\">" + string + "</span>";
    }

    public boolean didPass() {
        return this.tagContains(PASS);
    }

    public boolean didFail() {
        return this.tagContains(FAIL);
    }

    public boolean wasIgnored() {
        return this.tagContains(IGNORE);
    }

    public boolean hadError() {
        return this.tagContains(ERROR);
    }

    protected void ensureBodyNotNull() {
        if (this.parse.body == null) {
            this.parse.body = "";
        }
    }

    private boolean tagContains(String label) {
        return this.parse.tag.indexOf(label) >= 0;
    }

    protected abstract void error(TestResults var1, Throwable var2);
}

