/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fit.Parse;
import fitlibrary.exception.FitLibraryShowException;
import fitlibrary.exception.table.MissingCellsException;
import fitlibrary.global.PlugBoard;
import fitlibrary.table.Cell;
import fitlibrary.table.ParseNode;
import fitlibrary.traverse.Evaluator;
import fitlibrary.utility.ExtendedCamelCase;
import fitlibrary.utility.ParseUtility;
import fitlibrary.utility.TestResults;

public class Row
extends ParseNode {
    private boolean rowIsHidden = false;

    public Row(Parse parse) {
        super(parse);
    }

    public Row() {
        this(new Parse("tr", "", null, null));
    }

    public Row(String ... ss) {
        this();
        for (String s : ss) {
            this.addCell(s);
        }
    }

    public int size() {
        if (this.parse.parts == null) {
            return 0;
        }
        return this.parse.parts.size();
    }

    public Cell cell(int i) {
        if (!this.cellExists(i)) {
            throw new MissingCellsException("");
        }
        return new Cell(this.parse.parts.at(i));
    }

    public boolean cellExists(int i) {
        return i >= 0 && i < this.size();
    }

    public String toString() {
        return "Row[" + ParseUtility.toString(this.parse.parts) + "]";
    }

    public void pass(TestResults testResults) {
        if (this.rowIsHidden) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.pass(testResults);
    }

    public void fail(TestResults testResults) {
        if (this.rowIsHidden) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.fail(testResults);
    }

    public void error(TestResults testResults, Throwable throwable) {
        Throwable e = PlugBoard.exceptionHandling.unwrapThrowable(throwable);
        if (e instanceof FitLibraryShowException) {
            this.handleShow((FitLibraryShowException)e);
        } else {
            this.cell(0).error(testResults, e);
        }
    }

    private void handleShow(FitLibraryShowException exception) {
        Cell cell = this.addCell();
        cell.setText(exception.getResult().getHtmlString());
        cell.shown();
    }

    public String text(int i, Evaluator evaluator) {
        return this.cell(i).text(evaluator);
    }

    public void missing(TestResults testResults) {
        this.cell(0).expectedElementMissing(testResults);
    }

    public Cell addCell() {
        Cell cell = new Cell("");
        this.addCell(cell);
        return cell;
    }

    public Row addCell(Cell cell) {
        if (this.rowIsHidden) {
            System.out.println("Bug: Adding a cell to a hidden row in a table");
        }
        if (this.parse.parts == null) {
            this.parse.parts = cell.parse;
        } else {
            this.parse.parts.last().more = cell.parse;
        }
        return this;
    }

    public Cell addCell(String text) {
        Cell cell = new Cell(text);
        this.addCell(cell);
        return cell;
    }

    public Cell addCell(String text, int cols) {
        Cell cell = new Cell(text, cols);
        this.addCell(cell);
        return cell;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Row)) {
            return false;
        }
        Row other = (Row)object;
        if (other.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.cell(i).equals(other.cell(i))) continue;
            return false;
        }
        return true;
    }

    public Row rowFrom(int i) {
        return new Row(new Parse("tr", "", this.parse.parts.at(i), null));
    }

    public Cell last() {
        return this.cell(this.size() - 1);
    }

    public void ignore(TestResults testResults) {
        for (int i = 0; i < this.size(); ++i) {
            this.cell(i).ignore(testResults);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void setIsHidden() {
        this.rowIsHidden = true;
        for (int i = 0; i < this.size(); ++i) {
            this.cell(i).setIsHidden();
        }
    }

    public Cell lastCell() {
        return this.cell(this.size() - 1);
    }

    public void addCommentRow(Cell cell) {
        Row commentRow = new Row();
        commentRow.addCell("note");
        commentRow.addCell(cell);
        Parse next = this.parse.more;
        this.parse.more = commentRow.parse;
        commentRow.parse.more = next;
    }

    public Row rowTo(int from, int upto) {
        Row row = new Row();
        for (int i = from; i < upto; ++i) {
            row.addCell(new Cell(this.cell(i)));
        }
        return row;
    }

    public void passKeywords(TestResults testResults) {
        for (int i = 0; i < this.size(); i += 2) {
            this.cell(i).pass(testResults);
        }
    }

    public Row copy() {
        Row rowCopy = new Row();
        for (int i = 0; i < this.size(); ++i) {
            rowCopy.addCell(new Cell(this.cell(i).fullText()));
        }
        return rowCopy;
    }

    public void removeFirstCell() {
        this.parse.parts = this.parse.parts.more;
    }

    public void removeAllCells() {
        this.parse.parts = null;
    }

    public String methodNameForPlain(Evaluator evaluator) {
        String name = "";
        for (int i = 0; i < this.size(); i += 2) {
            name = name + this.text(i, evaluator);
            if (i + 1 >= this.size()) continue;
            name = name + "|";
        }
        return name;
    }

    public String methodNameForCamel(Evaluator evaluator) {
        String name = "";
        for (int i = 0; i < this.size(); i += 2) {
            name = name + this.text(i, evaluator) + " ";
        }
        return ExtendedCamelCase.camel(name.trim());
    }

    public int argumentCount() {
        return this.size() / 2;
    }

    public boolean hasFurtherRows() {
        return this.parse.more != null;
    }

    public int getColumnSpan() {
        int col = 0;
        for (int i = 0; i < this.size(); ++i) {
            col += this.cell(i).getColumnSpan();
        }
        return col;
    }

    public void setColumnSpan(int span) {
        if (this.isEmpty()) {
            this.addCell();
        }
        this.lastCell().setColumnSpan(span - this.getColumnSpan() + this.lastCell().getColumnSpan());
    }

    public int hashCode() {
        return super.hashCode();
    }
}

