/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fitlibrary.diff.Diff_match_patch;
import fitlibrary.table.ParseNode;
import fitlibrary.table.StringDifferencing;
import java.util.LinkedList;

public class StringDifferencingStandard
implements StringDifferencing {
    public void mustBeThreadSafe() {
    }

    public String differences(String actual, String expected) {
        if (actual.length() < 5 || expected.length() < 5) {
            return "";
        }
        LinkedList<Diff_match_patch.Diff> diffs = new Diff_match_patch().diff_main(actual, expected, true);
        StringBuilder s = new StringBuilder();
        int sameCount = 0;
        int sameButOneCount = 0;
        int sameMax = 0;
        for (Diff_match_patch.Diff diff : diffs) {
            String text = diff.text;
            int length = text.length();
            switch (diff.operation) {
                case DELETE: {
                    s.append("<strike>" + this.subst(text) + "</strike>");
                    break;
                }
                case EQUAL: {
                    s.append("<divv style='color:white'>" + text + "</divv>");
                    sameCount += length;
                    if (length == 1) {
                        ++sameButOneCount;
                    }
                    sameMax = Math.max(sameMax, length);
                    break;
                }
                case INSERT: {
                    s.append("<b>" + this.subst(text) + "</b>");
                }
            }
        }
        if (sameButOneCount * 10 > sameCount && sameMax < 3) {
            return "";
        }
        String result = s.toString();
        if (result.contains("  ") || result.contains("&nbsp")) {
            result = result.replace("  ", this.visibleSpace() + this.visibleSpace());
        }
        return "<hr>" + result + ParseNode.label("diff");
    }

    protected String visibleSpace() {
        return "&Delta;";
    }

    protected String subst(String sOriginal) {
        String s = sOriginal;
        if (s.startsWith(" ")) {
            s = this.visibleSpace() + s.substring(1);
        }
        if (s.endsWith(" ")) {
            s = s.substring(0, s.length() - 1) + this.visibleSpace();
        }
        return s;
    }
}

