/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fit.Parse;
import fitlibrary.exception.table.MissingRowException;
import fitlibrary.table.ParseNode;
import fitlibrary.table.Row;
import fitlibrary.table.Tables;
import fitlibrary.utility.ParseUtility;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;
import java.util.Random;

public class Table
extends ParseNode {
    private static final Random random = new Random();
    private int firstErrorRow = 0;

    public Table() {
        super(new Parse("table", "", null, null));
    }

    public Table(Parse parse) {
        super(parse);
    }

    public Table(Row row) {
        super(new Parse("table", "", row.parse, null));
    }

    public int size() {
        if (this.parse == null || this.parse.parts == null) {
            return 0;
        }
        return this.parse.parts.size();
    }

    public Row row(int i) {
        if (!this.rowExists(i)) {
            throw new MissingRowException("");
        }
        return new Row(this.parse.parts.at(i));
    }

    public boolean rowExists(int i) {
        return i >= 0 && i < this.size();
    }

    public String toString() {
        return "Table[" + ParseUtility.toString(this.parse.parts) + "]";
    }

    public void wrong(TestResults testResults, String msg) {
        this.row(this.firstErrorRow).cell(0).fail(testResults, msg);
    }

    public void missing(TestResults testResults) {
        this.row(this.firstErrorRow).missing(testResults);
    }

    public void ignore(TestResults testResults) {
        this.row(this.firstErrorRow).ignore(testResults);
    }

    public void error(TestResults testResults, Throwable e) {
        this.row(this.firstErrorRow).error(testResults, e);
    }

    public void error(TableListener tableListener, Exception e) {
        this.error(tableListener.getTestResults(), (Throwable)e);
    }

    public Row lastRow() {
        return this.row(this.size() - 1);
    }

    public void addRow(Row row) {
        if (this.parse.parts == null) {
            this.parse.parts = row.parse;
        } else {
            this.parse.parts.last().more = row.parse;
        }
    }

    public Row newRow() {
        Row row = new Row();
        this.addRow(row);
        return row;
    }

    public void finished(TableListener listener) {
        listener.tableFinished(this);
    }

    public Table withDummyFirstRow() {
        Parse firstRow = new Parse("tr", "", new Parse("td", "empty", null, null), this.parse.parts);
        Parse pseudoTable = new Parse("table", "", firstRow, null);
        Table table = new Table(pseudoTable);
        table.setFirstRowIsHidden();
        return table;
    }

    private void setFirstRowIsHidden() {
        this.firstErrorRow = 1;
        this.row(0).setIsHidden();
    }

    public Parse parse() {
        return this.parse;
    }

    public int phaseBoundaryCount() {
        int count = this.parse.leader.split("<hr>").length - 1;
        if (count == 0) {
            count = this.parse.leader.split("<hr/>").length - 1;
        }
        return count;
    }

    public void addToLeader(String s) {
        this.parse.leader = this.parse.leader + s;
    }

    public void addToStartOfLeader(String s) {
        this.parse.leader = s + this.parse.leader;
    }

    public void addToTrailer(String s) {
        if (this.parse.trailer == null) {
            this.parse.trailer = "";
        }
        this.parse.trailer = this.parse.trailer + s;
    }

    public void removeNext() {
        this.parse.more = this.parse.more.more;
    }

    public String getLeading() {
        return this.parse.leader;
    }

    public String getTrailing() {
        return this.parse.trailer;
    }

    public void addFoldingText(String text) {
        if ("".equals(text) || "\n".equals(text)) {
            return;
        }
        String id = Table.getId();
        String fold = "<div class=\"included\">\n<div style=\"float: right;\" class=\"meta\"><a href=\"javascript:expandAll();\">Expand All</a> | <a href=\"javascript:collapseAll();\">Collapse All</a></div><a href=\"javascript:toggleCollapsable('" + id + "');\">" + "<img src=\"/files/images/collapsableClosed.gif\" class=\"left\" id=\"img" + id + "\"/></a>" + "&nbsp;<span class=\"meta\">Logs</span><div class=\"hidden\" id=\"" + id + "\"><pre>" + text + "</pre></div></div>";
        if (this.parse.more != null) {
            new Table(this.parse.more).addToStartOfLeader(fold);
        } else {
            this.addToTrailer(fold);
        }
    }

    private static synchronized String getId() {
        return "" + random.nextInt();
    }

    public Tables getTables() {
        return new Tables(this.parse);
    }

    public void insertTable(int offset, Table table) {
        table.evenUpRows();
        Parse insertPoint = this.parse.at(offset);
        table.parse().more = insertPoint.more;
        insertPoint.more = table.parse();
    }

    public void evenUpRows() {
        int maxRowLength = this.getMaxRowColumnSpan();
        for (int rowNo = 0; rowNo < this.size(); ++rowNo) {
            this.row(rowNo).setColumnSpan(maxRowLength);
        }
    }

    private int getMaxRowColumnSpan() {
        int maxLength = 0;
        for (int rowNo = 0; rowNo < this.size(); ++rowNo) {
            Row row = this.row(rowNo);
            maxLength = Math.max(maxLength, row.getColumnSpan());
        }
        return maxLength;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Table)) {
            return false;
        }
        Table other = (Table)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.row(i).equals(other.row(i))) continue;
            return false;
        }
        return true;
    }
}

