/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fit.Parse;
import fit.exception.FitParseException;
import fitlibrary.table.Table;
import fitlibrary.utility.ParseUtility;
import fitlibrary.utility.SimpleWikiTranslator;
import fitlibrary.utility.TableListener;

public class Tables {
    public Parse parse;

    public Tables() {
    }

    public Tables(Parse parse) {
        this.parse = parse;
    }

    public Tables(Table theTable) {
        this(theTable.parse);
    }

    public Tables(String html) throws FitParseException {
        this(new Parse(html));
    }

    public Table table(int i) {
        return new Table(this.parse.at(i));
    }

    public void add(Table table) {
        if (this.parse == null) {
            this.parse = table.parse;
        } else {
            this.parse.last().more = table.parse;
        }
    }

    public int size() {
        return this.parse.size();
    }

    public String toString() {
        return "Tables[" + ParseUtility.toString(this.parse) + "]";
    }

    public Parse parse() {
        return this.parse;
    }

    public Tables withExtraTableInFront() {
        Parse tablesWithTableInFront = new Parse("table", "", new Parse("tr", "", null, null), this.parse);
        return new Tables(tablesWithTableInFront);
    }

    public void ignoreAndFinished(TableListener tableListener) {
        this.table(0).finished(tableListener);
        for (int i = 1; i < this.size(); ++i) {
            Table table = this.table(i);
            table.ignore(tableListener.getTestResults());
            table.finished(tableListener);
        }
        tableListener.storytestFinished();
    }

    public Table last() {
        return new Table(this.parse.last());
    }

    public Tables deepCopy() {
        return new Tables(ParseUtility.copyParse(this.parse));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Tables)) {
            return false;
        }
        Tables other = (Tables)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.table(i).equals(other.table(i))) continue;
            return false;
        }
        return true;
    }

    public Tables followingTables() {
        return new Tables(this.parse.more);
    }

    public static Tables fromWiki(String wiki) throws FitParseException {
        return new Tables(new Parse(SimpleWikiTranslator.translate(wiki)));
    }
}

