/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse;

import fitlibrary.DomainFixture;
import fitlibrary.collection.CollectionSetUpTraverse;
import fitlibrary.collection.CollectionTraverse;
import fitlibrary.collection.list.ListTraverse;
import fitlibrary.collection.set.SetTraverse;
import fitlibrary.object.DomainObjectCheckTraverse;
import fitlibrary.object.DomainObjectSetUpTraverse;
import fitlibrary.traverse.Traverse;
import fitlibrary.traverse.workflow.DoTraverse;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitLibrarySelector {
    public static final Ordering ORDERED = new Ordering();
    public static final Ordering UNORDERED = new Ordering();
    public static final Subset EXPECT_ALL = new Subset();
    public static final Subset EXPECT_SOME = new Subset();

    public static Traverse selectWorkflow(Object sut) {
        return new DoTraverse(sut);
    }

    public static CollectionTraverse selectUnorderedList(Object actuals) {
        CollectionTraverse traverse = FitLibrarySelector.selectUnorderedList();
        traverse.setActualCollection(actuals);
        return traverse;
    }

    public static CollectionTraverse selectUnorderedList() {
        return FitLibrarySelector.select(UNORDERED, EXPECT_ALL);
    }

    public static CollectionTraverse selectOrderedList(Object actuals) {
        CollectionTraverse traverse = FitLibrarySelector.selectOrderedList();
        traverse.setActualCollection(actuals);
        return traverse;
    }

    public static CollectionTraverse selectOrderedList() {
        return FitLibrarySelector.select(ORDERED, EXPECT_ALL);
    }

    public static CollectionTraverse selectSet(Object actuals) {
        CollectionTraverse traverse = FitLibrarySelector.selectSet();
        traverse.setActualCollection(actuals);
        return traverse;
    }

    public static CollectionTraverse selectSet() {
        return FitLibrarySelector.select(UNORDERED, EXPECT_ALL);
    }

    public static CollectionTraverse selectSubset(Object actuals) {
        CollectionTraverse traverse = FitLibrarySelector.selectSubset();
        traverse.setActualCollection(actuals);
        return traverse;
    }

    public static CollectionTraverse selectSubset() {
        return FitLibrarySelector.select(UNORDERED, EXPECT_SOME);
    }

    private static CollectionTraverse select(Ordering ordering, Subset subset) {
        CollectionTraverse traverse = ordering == ORDERED ? new ListTraverse() : new SetTraverse();
        if (subset == EXPECT_SOME) {
            traverse.setShowSurplus(false);
        }
        return traverse;
    }

    public static CollectionSetUpTraverse selectCollectionSetUp() {
        return new CollectionSetUpTraverse();
    }

    public static CollectionSetUpTraverse selectCollectionSetUp(Collection<Object> collection) {
        return new CollectionSetUpTraverse(collection);
    }

    public static DomainObjectCheckTraverse selectDomainCheck(Object domainObject) {
        return new DomainObjectCheckTraverse(domainObject);
    }

    public static DomainObjectSetUpTraverse selectDomainSetUp(Object domainObject) {
        return new DomainObjectSetUpTraverse(domainObject);
    }

    public static DomainFixture selectDomain(Object sut) {
        return new DomainFixture(sut);
    }

    static class Header {
        Header() {
        }
    }

    static class Subset {
        Subset() {
        }
    }

    static class Ordering {
        Ordering() {
        }
    }
}

