/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse;

import fitlibrary.parser.Parser;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.TestResults;

public class GridTraverse
extends Traverse {
    private Object[][] grid;
    private Parser parser;

    public GridTraverse(Object sut) {
        super(sut);
    }

    public void setGrid(Object[][] grid) {
        this.grid = grid;
        this.parser = GridTraverse.asTyped(grid).getComponentTyped().getComponentTyped().parser(this);
    }

    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        if (this.grid.length == 0 && table.size() == 1) {
            table.pass(testResults);
        } else if (!this.rowsMatch(this.grid, table, testResults)) {
            this.addActualRows(table, this.grid);
        }
        return this.grid;
    }

    private boolean rowsMatch(Object[][] actual, Table table, TestResults testResults) {
        int rowNo;
        boolean matched = true;
        for (rowNo = 0; rowNo < actual.length; ++rowNo) {
            if (!table.rowExists(rowNo + 1)) {
                return false;
            }
            Row row = table.row(rowNo + 1);
            if (this.cellsMatch(actual[rowNo], row, testResults)) continue;
            matched = false;
        }
        for (rowNo = actual.length + 1; rowNo < table.size(); ++rowNo) {
            matched = false;
            table.row(rowNo).fail(testResults);
        }
        return matched;
    }

    private boolean cellsMatch(Object[] actual, Row row, TestResults testResults) {
        boolean matched = true;
        for (int i = 0; i < actual.length; ++i) {
            if (!row.cellExists(i)) {
                return false;
            }
            if (this.cellMatches(actual[i], row.cell(i), testResults)) continue;
            matched = false;
        }
        for (int cellNo = actual.length; cellNo < row.size(); ++cellNo) {
            matched = false;
            row.cell(cellNo).fail(testResults);
        }
        return matched;
    }

    private boolean cellMatches(Object actual, Cell cell, TestResults testResults) {
        boolean matches = false;
        try {
            matches = this.parser.matches(cell, actual, testResults);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (matches) {
            cell.pass(testResults);
        } else {
            cell.fail(testResults);
        }
        return matches;
    }

    private void addActualRows(Table table, Object[][] actual) {
        int i;
        int cols = 0;
        for (int rowNo = 0; rowNo < table.size(); ++rowNo) {
            cols = Math.max(cols, table.row(rowNo).size());
        }
        for (i = 0; i < actual.length; ++i) {
            cols = Math.max(cols, actual[i].length);
        }
        table.newRow().addCell("<i>Actuals:</i>", cols);
        for (i = 0; i < actual.length; ++i) {
            this.makeRow(table.newRow(), actual[i]);
        }
    }

    private void makeRow(Row row, Object[] actuals) {
        if (actuals.length == 0) {
            throw new RuntimeException("Actuals row empty");
        }
        for (int i = 0; i < actuals.length; ++i) {
            row.addCell(this.cellWithValue(actuals[i]));
        }
    }

    private Cell cellWithValue(Object object) {
        Cell cell = new Cell();
        try {
            cell.setUnvisitedText(this.parser.show(object));
        }
        catch (Exception e) {
            cell.setUnvisitedText(e.toString());
        }
        return cell;
    }
}

