/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.closure.Closure;
import fitlibrary.differences.DifferenceInterface;
import fitlibrary.differences.FitNesseDifference;
import fitlibrary.differences.LocalFile;
import fitlibrary.dynamicVariable.DynamicVariables;
import fitlibrary.exception.CycleException;
import fitlibrary.global.PlugBoard;
import fitlibrary.parser.lookup.ParseDelegation;
import fitlibrary.runtime.RuntimeContext;
import fitlibrary.table.Table;
import fitlibrary.traverse.AlienTraverseHandler;
import fitlibrary.traverse.DomainAdapter;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedFactory;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ExtendedCamelCase;
import fitlibrary.utility.TestResults;
import fitlibraryGeneric.typed.GenericTypedFactory;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Traverse
implements Evaluator {
    protected static DifferenceInterface FITNESSE_DIFFERENCES = new FitNesseDifference();
    protected static AlienTraverseHandler ALIEN_TRAVERSE_HANDLER = new AlienTraverseHandler();
    public static final String FITNESSE_URL_KEY = "fitNesse.url";
    private static final TypedFactory factory = new GenericTypedFactory();
    private TypedObject typedObjectUnderTest = new GenericTypedObject(null);
    private Evaluator outerContext = null;
    private boolean setUpAlreadyCalled = false;
    private boolean tearDownAlreadyCalled = false;
    protected boolean canTearDown = true;
    protected RuntimeContext runtimeContext = new RuntimeContext();

    public Traverse() {
    }

    public Traverse(Object sut) {
        this.setSystemUnderTest(sut);
    }

    public Traverse(TypedObject typedObjectUnderTest) {
        this.typedObjectUnderTest = typedObjectUnderTest;
    }

    protected void registerParseDelegate(Class<?> type, Class<?> parseDelegate) {
        ParseDelegation.registerParseDelegate(type, parseDelegate);
    }

    protected void registerParseDelegate(Class<?> type, Object parseDelegate) {
        ParseDelegation.registerParseDelegate(type, parseDelegate);
    }

    protected void registerSuperParseDelegate(Class<?> type, Object superParseDelegate) {
        ParseDelegation.registerSuperParseDelegate(type, superParseDelegate);
    }

    public void setSystemUnderTest(Object sut) {
        if (this.cycleSUT(this, sut)) {
            throw new CycleException("systemUnderTest", this, sut);
        }
        this.typedObjectUnderTest = Traverse.asTypedObject(sut);
    }

    private boolean cycleSUT(DomainAdapter domainAdapter, Object sut) {
        if (domainAdapter == sut) {
            return true;
        }
        if (sut instanceof DomainAdapter) {
            return this.cycleSUT(domainAdapter, ((DomainAdapter)sut).getSystemUnderTest());
        }
        return false;
    }

    @Override
    public Object getSystemUnderTest() {
        if (this.typedObjectUnderTest == null) {
            return null;
        }
        return this.typedObjectUnderTest.getSubject();
    }

    @Override
    public TypedObject getTypedSystemUnderTest() {
        return this.typedObjectUnderTest;
    }

    public void setTypedSystemUnderTest(TypedObject typedObjectUnderTest) {
        this.typedObjectUnderTest = typedObjectUnderTest;
    }

    @Override
    public void setOuterContext(Evaluator outerContext) {
        if (this.outerContext == outerContext || this == outerContext) {
            return;
        }
        if (Traverse.cycleOC(this, outerContext)) {
            throw new CycleException("outerContext", this, outerContext);
        }
        this.outerContext = outerContext;
    }

    private static boolean cycleOC(DomainAdapter domainAdapter, Evaluator oc) {
        if (domainAdapter == oc) {
            return true;
        }
        if (oc != null) {
            return Traverse.cycleOC(domainAdapter, oc.getNextOuterContext());
        }
        return false;
    }

    @Override
    public Evaluator getNextOuterContext() {
        return this.outerContext;
    }

    @Override
    public Object getOutermostContext() {
        Evaluator context = this.getNextOuterContext();
        if (context == null) {
            return this;
        }
        return context.getOutermostContext();
    }

    public static void setDifferenceStrategy(DifferenceInterface difference) {
        FITNESSE_DIFFERENCES = difference;
    }

    public static LocalFile getLocalFile(String localFileName) {
        return FITNESSE_DIFFERENCES.getLocalFile(localFileName);
    }

    public static LocalFile getGlobalFile(String localFileName) {
        return FITNESSE_DIFFERENCES.getGlobalFile(localFileName);
    }

    public static String htmlLink(File file) {
        return FITNESSE_DIFFERENCES.getGlobalFile(file).htmlLink();
    }

    public static void setContext(File reportDiry) {
        FITNESSE_DIFFERENCES.setContext(reportDiry);
    }

    public static String escapeHtml(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    protected String camelCase(String suppliedName) {
        return ExtendedCamelCase.camel(suppliedName);
    }

    public void theSetUpTearDownAlreadyHandled() {
        this.setUpAlreadyCalled = true;
        this.tearDownAlreadyCalled = true;
    }

    @Override
    public void setUp(Table table, TestResults testResults) {
        try {
            this.setUp();
        }
        catch (Exception e) {
            table.error(testResults, (Throwable)e);
        }
    }

    @Override
    public void setUp() throws Exception {
        if (this.setUpAlreadyCalled) {
            return;
        }
        this.setUpAlreadyCalled = true;
        CalledMethodTarget methodTarget = this.asTypedObject().optionallyFindMethodOnTypedObject("setUp", 0, this, false);
        if (methodTarget == null) {
            return;
        }
        methodTarget.invoke();
    }

    @Override
    public void tearDown(Table table, TestResults testResults) {
        try {
            if (!testResults.inSuiteFixtureSoDoNotTearDown()) {
                this.tearDown();
            }
        }
        catch (Exception e) {
            table.error(testResults, (Throwable)e);
        }
    }

    @Override
    public void tearDown() throws Exception {
        if (!this.canTearDown || this.tearDownAlreadyCalled) {
            return;
        }
        this.tearDownAlreadyCalled = true;
        CalledMethodTarget methodTarget = this.asTypedObject().optionallyFindMethodOnTypedObject("tearDown", 0, this, false);
        if (methodTarget == null) {
            return;
        }
        methodTarget.invoke();
    }

    public void interpretWithinContext(Table table, Evaluator evaluator, TestResults testResults) {
        this.setOuterContext(evaluator);
        this.interpretAfterFirstRow(table, testResults);
    }

    public void interpretInnerTable(Table table, Evaluator evaluator, TestResults testResults) {
        this.setOuterContext(evaluator);
        this.interpretAfterFirstRow(table.withDummyFirstRow(), testResults);
    }

    public boolean doesInnerTablePass(Table table, Evaluator evaluator, TestResults testResults) {
        TestResults innerResults = new TestResults();
        this.interpretInnerTable(table, evaluator, innerResults);
        testResults.add(innerResults);
        return innerResults.passed();
    }

    public boolean doesTablePass(Table table, Evaluator evaluator, TestResults testResults) {
        this.setOuterContext(evaluator);
        TestResults innerResults = new TestResults();
        this.interpretAfterFirstRow(table, innerResults);
        testResults.add(innerResults);
        return innerResults.passed();
    }

    public static AlienTraverseHandler getAlienTraverseHandler() {
        return ALIEN_TRAVERSE_HANDLER;
    }

    public static void setAlienTraverseHandler(AlienTraverseHandler handler) {
        ALIEN_TRAVERSE_HANDLER = handler;
    }

    public static Typed asTyped(Class<?> type) {
        return factory.asTyped(type);
    }

    public static Typed asTyped(Object object) {
        return factory.asTyped(object.getClass());
    }

    public static Typed asTyped(Method method) {
        return factory.asTyped(method);
    }

    protected TypedObject asTypedObject() {
        return factory.asTypedObject(this);
    }

    public static TypedObject asTypedObject(Object sut) {
        if (sut instanceof TypedObject) {
            return (TypedObject)sut;
        }
        return factory.asTypedObject(sut);
    }

    public void callStartCreatingObjectMethod(TypedObject object) throws IllegalAccessException, InvocationTargetException {
        if (object != null) {
            this.callCreatingMethod("startCreatingObject", object.getSubject());
        }
    }

    public void callStartCreatingObjectMethod(Object element) throws IllegalAccessException, InvocationTargetException {
        this.callCreatingMethod("startCreatingObject", element);
    }

    public void callEndCreatingObjectMethod(TypedObject object) throws IllegalAccessException, InvocationTargetException {
        if (object != null) {
            this.callCreatingMethod("endCreatingObject", object.getSubject());
        }
    }

    public void callEndCreatingObjectMethod(Object element) throws IllegalAccessException, InvocationTargetException {
        this.callCreatingMethod("endCreatingObject", element);
    }

    @Override
    public RuntimeContext runtime() {
        return this.runtimeContext;
    }

    public DynamicVariables getDynamicVariables() {
        return this.runtime().dynamicVariables();
    }

    @Override
    public void setRuntimeContext(RuntimeContext globalRuntimeContext) {
        this.runtimeContext = globalRuntimeContext;
    }

    @Override
    public void setDynamicVariable(String key, Object value) {
        this.getDynamicVariables().put(key, value);
    }

    public Object getDynamicVariable(String key) {
        return this.getDynamicVariables().get(key);
    }

    protected String fitNesseUrl() {
        return this.getDynamicVariable(FITNESSE_URL_KEY).toString();
    }

    private void callCreatingMethod(String creatingMethodName, Object element) throws IllegalAccessException, InvocationTargetException {
        Closure startCreatingMethod = PlugBoard.lookupTarget.findFixturingMethod(this, creatingMethodName, new Class[]{Object.class});
        if (startCreatingMethod != null) {
            startCreatingMethod.invoke(new Object[]{element});
        }
    }

    @Override
    public abstract Object interpretAfterFirstRow(Table var1, TestResults var2);
}

