/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow;

import fit.Fixture;
import fitlibrary.DefineAction;
import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.definedAction.DefineActionsOnPage;
import fitlibrary.definedAction.DefineActionsOnPageSlowly;
import fitlibrary.definedAction.DefinedActionTraverse;
import fitlibrary.definedAction.UseTemplateTraverse;
import fitlibrary.dynamicVariable.RecordDynamicVariables;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.FitLibraryShowException;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.NotRejectedException;
import fitlibrary.exception.parse.ParseException;
import fitlibrary.exception.table.MissingCellsException;
import fitlibrary.global.PlugBoard;
import fitlibrary.global.TemporaryPlugBoardForRuntime;
import fitlibrary.parser.graphic.GraphicParser;
import fitlibrary.parser.graphic.ObjectDotGraphic;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.traverse.CommentTraverse;
import fitlibrary.traverse.function.CalculateTraverse;
import fitlibrary.traverse.function.ConstraintTraverse;
import fitlibrary.traverse.workflow.DoTraverseInterpreter;
import fitlibrary.traverse.workflow.PlainText;
import fitlibrary.traverse.workflow.RandomSelectTraverse;
import fitlibrary.traverse.workflow.SetVariableTraverse;
import fitlibrary.traverse.workflow.StopWatch;
import fitlibrary.traverse.workflow.caller.CallManager;
import fitlibrary.traverse.workflow.caller.DefinedActionCaller;
import fitlibrary.typed.NonGenericTyped;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ClassUtility;
import fitlibrary.utility.FileHandler;
import fitlibrary.utility.TestResults;
import fitlibrary.xref.CrossReferenceFixture;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ognl.Ognl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoTraverse
extends DoTraverseInterpreter {
    private static final String STOP_WATCH = "$$STOP WATCH$$";
    public static final String BECOMES_TIMEOUT = "becomes";
    private static final String[] methodsThatAreVisibleAsActions = new String[]{"calculate/0", "start/1", "constraint/0", "failingConstraint/0", "useTemplate/1", "template/1", "abandonStorytest/0", "setStopOnError/1", "becomesTimeout/0", "becomesTimeout/1", "comment/0", "ignore/0", "ignored/0", "ignoreTable/0", "clearDynamicVariables/0", "addDynamicVariablesFromFile/1", "recordToFile/1", "setVariables/0", "to/1", "get/1", "getDynamicVariables/0", "setExpandDefinedActions/1", "selectRandomly/1", "defineAction/0", "defineAction/1", "defineActionsAt/1", "defineActionsSlowlyAt/1", "clearDefinedActions/0", "startLogging/1", "logMessage/1", "showAfterTable/1", "addDynamicVariablesFromUnicodeFile/1", "file/1", "xref/1", "harvestUsingPatternFrom/3", "setSystemPropertyTo/2", "startStopWatch/0", "stopWatch/0", "sleepFor/1"};

    public void startStopWatch() {
        this.setDynamicVariable(STOP_WATCH, new StopWatch());
    }

    public long stopWatch() {
        return this.getStopWatch().delay();
    }

    private StopWatch getStopWatch() {
        StopWatch stopWatch = (StopWatch)this.getDynamicVariable(STOP_WATCH);
        if (stopWatch == null) {
            throw new FitLibraryException("No stopwatch started");
        }
        return stopWatch;
    }

    public boolean sleepFor(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    protected DoTraverse() {
    }

    public DoTraverse(Object sut) {
        super(sut);
    }

    public DoTraverse(TypedObject typedObject) {
        super(typedObject);
    }

    @Override
    public List<String> methodsThatAreVisible() {
        return Arrays.asList(methodsThatAreVisibleAsActions);
    }

    public CalculateTraverse calculate() {
        CalculateTraverse traverse = this.getClass() == DoTraverse.class ? new CalculateTraverse(this.getTypedSystemUnderTest()) : new CalculateTraverse(this);
        traverse.theSetUpTearDownAlreadyHandled();
        return traverse;
    }

    public void start(String className) {
        try {
            this.setSystemUnderTest(ClassUtility.newInstance(className));
        }
        catch (Exception e) {
            throw new FitLibraryException("Unknown class: " + className);
        }
    }

    public ConstraintTraverse constraint() {
        ConstraintTraverse traverse = new ConstraintTraverse(this);
        traverse.theSetUpTearDownAlreadyHandled();
        return traverse;
    }

    public ConstraintTraverse failingConstraint() {
        ConstraintTraverse traverse = new ConstraintTraverse(this, false);
        traverse.theSetUpTearDownAlreadyHandled();
        return traverse;
    }

    public void becomesTimeout(int timeout) {
        this.runtimeContext.putTimeout(BECOMES_TIMEOUT, timeout);
    }

    public int becomesTimeout() {
        return this.runtimeContext.getTimeout(BECOMES_TIMEOUT, 1000);
    }

    public UseTemplateTraverse useTemplate(String name) {
        return new UseTemplateTraverse(name);
    }

    public DefinedActionTraverse template(String name) {
        return new DefinedActionTraverse();
    }

    public void setStopOnError(boolean stopOnError) {
        TestResults.setStopOnError(stopOnError);
    }

    public void abandonStorytest() {
        TestResults.setAbandoned();
    }

    public CommentTraverse comment() {
        return new CommentTraverse();
    }

    public CommentTraverse ignored() {
        return this.ignore();
    }

    public CommentTraverse ignore() {
        return new CommentTraverse(true);
    }

    public CommentTraverse ignoreTable() {
        return new CommentTraverse(true);
    }

    public boolean clearDynamicVariables() {
        this.getDynamicVariables().clearAll();
        return true;
    }

    public boolean addDynamicVariablesFromFile(String fileName) {
        return this.getDynamicVariables().addFromPropertiesFile(fileName);
    }

    public void recordToFile(String fileName) {
        RecordDynamicVariables.recordToFile(fileName);
        try {
            this.addDynamicVariablesFromFile(fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SetVariableTraverse setVariables() {
        return new SetVariableTraverse();
    }

    public String to(String s) {
        return s;
    }

    public String get(String s) {
        return s;
    }

    public DefineAction defineAction() {
        return new DefineAction();
    }

    public DefineAction defineAction(String wikiClassName) {
        return new DefineAction(wikiClassName);
    }

    public DefineActionsOnPageSlowly defineActionsSlowlyAt(String pageName) {
        return new DefineActionsOnPageSlowly(pageName);
    }

    public DefineActionsOnPage defineActionsAt(String pageName) {
        return new DefineActionsOnPage(pageName);
    }

    public void clearDefinedActions() {
        TemporaryPlugBoardForRuntime.definedActionsRepository().clear();
    }

    public RandomSelectTraverse selectRandomly(String var) {
        return new RandomSelectTraverse(var);
    }

    public void startLogging(String fileName) {
        this.runtime().startLogging(fileName);
    }

    public void logMessage(String s) {
        try {
            this.runtime().printToLog(s);
        }
        catch (IOException e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public void showAfterTable(String s) {
        TestResults.logAfterTable(s + "\n");
    }

    public void addDynamicVariablesFromUnicodeFile(String fileName) throws IOException {
        this.getDynamicVariables().addFromUnicodePropertyFile(fileName);
    }

    public DoTraverse file(String fileName) {
        return new DoTraverse(new FileHandler(fileName));
    }

    public CrossReferenceFixture xref(String suiteName) {
        return new CrossReferenceFixture(suiteName);
    }

    public boolean harvestUsingPatternFrom(String[] vars, String pattern, String text) {
        Matcher matcher = Pattern.compile(pattern).matcher(text);
        if (!matcher.find()) {
            throw new FitLibraryException("Pattern doesn't match");
        }
        int groups = matcher.groupCount();
        if (vars.length > groups) {
            throw new FitLibraryException("Expected " + this.expectedGroups(vars) + ", but there " + this.actualGroups(groups));
        }
        for (int v = 0; v < vars.length && v < groups; ++v) {
            this.setDynamicVariable(vars[v], matcher.group(v + 1));
        }
        return true;
    }

    private String expectedGroups(String[] vars) {
        if (vars.length == 1) {
            return "1 bracketed group";
        }
        return vars.length + " bracketed groups";
    }

    private String actualGroups(int groups) {
        if (groups == 1) {
            return "is only 1";
        }
        return "are only " + groups;
    }

    public boolean setSystemPropertyTo(String property, String value) {
        System.setProperty(property, value);
        this.setDynamicVariable(property, value);
        return true;
    }

    public void is(TestResults testResults, Row row) throws Exception {
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("DoTraverseIs");
        }
        CalledMethodTarget target = this.findMethodFromRow(row, 0, less);
        Cell expectedCell = row.last();
        if (this.gatherExpectedForGeneration) {
            this.expectedResult = target.getResult(expectedCell, testResults);
        }
        target.invokeAndCheckForSpecial(row.rowTo(1, row.size() - 2), expectedCell, testResults, row, this.operatorCell(row));
    }

    public void equals(TestResults testResults, Row row) throws Exception {
        this.is(testResults, row);
    }

    public void isNot(TestResults testResults, Row row) throws Exception {
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("DoTraverseIs");
        }
        Cell specialCell = this.operatorCell(row);
        Cell expectedCell = row.last();
        try {
            CalledMethodTarget target = this.findMethodFromRow(row, 0, less);
            if (this.gatherExpectedForGeneration) {
                this.expectedResult = target.getResult(expectedCell, testResults);
            }
            Object result = target.invoke(row.rowTo(1, row.size() - 2), testResults, true);
            target.notResult(expectedCell, result, testResults);
        }
        catch (IgnoredException e) {
        }
        catch (InvocationTargetException e) {
            Throwable embedded = e.getTargetException();
            if (embedded instanceof FitLibraryShowException) {
                specialCell.error(testResults);
                row.error(testResults, e);
            } else {
                expectedCell.exceptionMayBeExpected(false, e, testResults);
            }
        }
        catch (Exception e) {
            expectedCell.exceptionMayBeExpected(false, e, testResults);
        }
    }

    public void lessThan(TestResults testResults, Row row) throws Exception {
        Comparison compare = new Comparison(){

            public boolean compares(Comparable actual, Comparable expected) {
                return actual.compareTo(expected) < 0;
            }
        };
        this.comparison(testResults, row, compare);
    }

    public void lessThanEquals(TestResults testResults, Row row) throws Exception {
        Comparison compare = new Comparison(){

            public boolean compares(Comparable actual, Comparable expected) {
                return actual.compareTo(expected) <= 0;
            }
        };
        this.comparison(testResults, row, compare);
    }

    public void greaterThan(TestResults testResults, Row row) throws Exception {
        Comparison compare = new Comparison(){

            public boolean compares(Comparable actual, Comparable expected) {
                return actual.compareTo(expected) > 0;
            }
        };
        this.comparison(testResults, row, compare);
    }

    public void greaterThanEquals(TestResults testResults, Row row) throws Exception {
        Comparison compare = new Comparison(){

            public boolean compares(Comparable actual, Comparable expected) {
                return actual.compareTo(expected) >= 0;
            }
        };
        this.comparison(testResults, row, compare);
    }

    private void comparison(TestResults testResults, Row row, Comparison compare) {
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("DoTraverseIs");
        }
        Cell specialCell = this.operatorCell(row);
        Cell expectedCell = row.last();
        try {
            Object result;
            CalledMethodTarget target = this.findMethodFromRow(row, 0, less);
            if (this.gatherExpectedForGeneration) {
                this.expectedResult = target.getResult(expectedCell, testResults);
            }
            if (!((result = target.invoke(row.rowTo(1, row.size() - 2), testResults, true)) instanceof Comparable)) {
                throw new FitLibraryException("Unable to compare, as not Comparable");
            }
            target.compare(expectedCell, (Comparable)result, testResults, compare);
        }
        catch (IgnoredException e) {
        }
        catch (InvocationTargetException e) {
            Throwable embedded = e.getTargetException();
            if (embedded instanceof FitLibraryShowException) {
                specialCell.error(testResults);
                row.error(testResults, e);
            } else {
                expectedCell.exceptionMayBeExpected(false, e, testResults);
            }
        }
        catch (Exception e) {
            expectedCell.exceptionMayBeExpected(false, e, testResults);
        }
    }

    private Cell operatorCell(Row row) {
        return row.cell(row.size() - 2);
    }

    public void matches(TestResults testResults, Row row) throws Exception {
        try {
            int less = 3;
            if (row.size() < less) {
                throw new MissingCellsException("DoTraverseMatches");
            }
            CalledMethodTarget target = this.findMethodFromRow(row, 0, less);
            Cell expectedCell = row.last();
            if (this.gatherExpectedForGeneration) {
                this.expectedResult = target.getResult(expectedCell, testResults);
            }
            String result = target.invokeForSpecial(row.rowTo(1, row.size() - 2), testResults, false, this.operatorCell(row)).toString();
            boolean matches = Pattern.compile(".*" + expectedCell.text(this) + ".*", 32).matcher(result).matches();
            if (matches) {
                expectedCell.pass(testResults);
            } else {
                expectedCell.fail(testResults, result, this);
            }
        }
        catch (PatternSyntaxException e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public void eventuallyMatches(TestResults testResults, Row row) throws Exception {
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("eventuallyMatches");
        }
        CalledMethodTarget target = this.findMethodFromRow(row, 0, less);
        Cell expectedCell = row.last();
        if (this.gatherExpectedForGeneration) {
            this.expectedResult = target.getResult(expectedCell, testResults);
        }
        Pattern compile = Pattern.compile(".*" + expectedCell.text(this) + ".*", 32);
        String result = "";
        long start = System.currentTimeMillis();
        int becomesTimeout = this.getTimeout(BECOMES_TIMEOUT);
        while (System.currentTimeMillis() - start < (long)becomesTimeout) {
            result = target.invokeForSpecial(row.rowTo(1, row.size() - 2), testResults, false, this.operatorCell(row)).toString();
            boolean matches = compile.matcher(result).matches();
            if (matches) {
                expectedCell.pass(testResults);
                return;
            }
            try {
                Thread.sleep(Math.max(500, Math.min(100, becomesTimeout / 10)));
            }
            catch (Exception e) {}
        }
        expectedCell.fail(testResults, result, this);
    }

    public void doesNotMatch(TestResults testResults, Row row) throws Exception {
        try {
            int less = 3;
            if (row.size() < less) {
                throw new MissingCellsException("DoTraverseMatches");
            }
            CalledMethodTarget target = this.findMethodFromRow(row, 0, less);
            Cell expectedCell = row.last();
            if (this.gatherExpectedForGeneration) {
                this.expectedResult = target.getResult(expectedCell, testResults);
            }
            String result = target.invokeForSpecial(row.rowTo(1, row.size() - 2), testResults, false, this.operatorCell(row)).toString();
            if (!Pattern.compile(".*" + expectedCell.text(this) + ".*", 32).matcher(result).matches()) {
                expectedCell.pass(testResults);
            } else if (expectedCell.text(this).equals(result)) {
                expectedCell.fail(testResults);
            } else {
                expectedCell.fail(testResults, result, this);
            }
        }
        catch (PatternSyntaxException e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public void contains(TestResults testResults, Row row) throws Exception {
        String result;
        boolean matches;
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("contains");
        }
        CalledMethodTarget target = this.findMethodFromRow(row, 0, less);
        Cell expectedCell = row.last();
        if (this.gatherExpectedForGeneration) {
            this.expectedResult = target.getResult(expectedCell, testResults);
        }
        if (matches = (result = target.invokeForSpecial(row.rowTo(1, row.size() - 2), testResults, false, this.operatorCell(row)).toString()).contains(expectedCell.text(this))) {
            expectedCell.pass(testResults);
        } else {
            expectedCell.failWithStringEquals(testResults, result, this);
        }
    }

    public void eventuallyContains(TestResults testResults, Row row) throws Exception {
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("contains");
        }
        CalledMethodTarget target = this.findMethodFromRow(row, 0, less);
        Cell expectedCell = row.last();
        if (this.gatherExpectedForGeneration) {
            this.expectedResult = target.getResult(expectedCell, testResults);
        }
        String result = "";
        long start = System.currentTimeMillis();
        int becomesTimeout = this.getTimeout(BECOMES_TIMEOUT);
        while (System.currentTimeMillis() - start < (long)becomesTimeout) {
            result = target.invokeForSpecial(row.rowTo(1, row.size() - 2), testResults, false, this.operatorCell(row)).toString();
            boolean matches = result.contains(expectedCell.text(this));
            if (!matches) continue;
            expectedCell.pass(testResults);
            return;
        }
        expectedCell.failWithStringEquals(testResults, result, this);
    }

    public void doesNotContain(TestResults testResults, Row row) throws Exception {
        String result;
        boolean matches;
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("doesNoContain");
        }
        CalledMethodTarget target = this.findMethodFromRow(row, 0, less);
        Cell expectedCell = row.last();
        if (this.gatherExpectedForGeneration) {
            this.expectedResult = target.getResult(expectedCell, testResults);
        }
        if (!(matches = (result = target.invokeForSpecial(row.rowTo(1, row.size() - 2), testResults, false, this.operatorCell(row)).toString()).contains(expectedCell.text(this)))) {
            expectedCell.pass(testResults);
        } else {
            expectedCell.fail(testResults, result, this);
        }
    }

    public void becomes(TestResults testResults, Row row) throws Exception {
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("DoTraverseMatches");
        }
        CalledMethodTarget target = this.findMethodFromRow(row, 0, less);
        Cell expectedCell = row.last();
        Row actionPartOfRow = row.rowTo(1, row.size() - 2);
        long start = System.currentTimeMillis();
        int becomesTimeout = this.getTimeout(BECOMES_TIMEOUT);
        while (System.currentTimeMillis() - start < (long)becomesTimeout) {
            Object result = target.invokeForSpecial(actionPartOfRow, testResults, false, this.operatorCell(row));
            if (target.getResultParser().matches(expectedCell, result, testResults)) break;
            try {
                Thread.sleep(Math.min(100, becomesTimeout / 10));
            }
            catch (Exception e) {}
        }
        target.invokeAndCheckForSpecial(actionPartOfRow, expectedCell, testResults, row, this.operatorCell(row));
    }

    public void check(Row row, TestResults testResults) throws Exception {
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("DoTraverseCheck");
        }
        CalledMethodTarget target = this.findMethodFromRow(row, 1, less);
        Cell expectedCell = row.last();
        if (this.gatherExpectedForGeneration) {
            this.expectedResult = target.getResult(expectedCell, testResults);
        }
        target.invokeAndCheckForSpecial(row.rowFrom(2), expectedCell, testResults, row, row.cell(0));
    }

    public void reject(Row row, TestResults testResults) throws Exception {
        this.not(row, testResults);
    }

    public void not(Row row, TestResults testResults) throws Exception {
        Cell notCell = row.cell(0);
        this.expectedResult = new Boolean(false);
        try {
            Object result = this.callMethodInRow(row, testResults, false, row.cell(0));
            if (!(result instanceof Boolean)) {
                notCell.error(testResults, new NotRejectedException());
            } else if (((Boolean)result).booleanValue()) {
                notCell.fail(testResults);
            } else {
                notCell.pass(testResults);
            }
        }
        catch (IgnoredException e) {
        }
        catch (FitLibraryException e) {
            if (e instanceof ParseException) {
                notCell.pass(testResults);
            } else {
                row.error(testResults, e);
            }
        }
        catch (InvocationTargetException e) {
            Throwable embedded = e.getTargetException();
            if (embedded instanceof FitLibraryShowException) {
                row.error(testResults, embedded);
            } else {
                notCell.pass(testResults);
            }
        }
        catch (Exception e) {
            notCell.pass(testResults);
        }
    }

    public void show(Row row, TestResults testResults) throws Exception {
        try {
            CalledMethodTarget target = this.findMethodFromRow(row, 1, 2);
            Object result = target.invokeForSpecial(row.rowFrom(2), testResults, true, row.cell(0));
            row.addCell(target.getResultString(result)).shown();
            CallManager.addShow(row);
        }
        catch (IgnoredException ignoredException) {
            // empty catch block
        }
    }

    public void showAfter(Row row, TestResults testResults) throws Exception {
        try {
            CalledMethodTarget target = this.findMethodFromRow(row, 1, 2);
            Object result = target.invokeForSpecial(row.rowFrom(2), testResults, true, row.cell(0));
            this.showAfterTable(target.getResultString(result));
        }
        catch (IgnoredException ignoredException) {
            // empty catch block
        }
    }

    public void showEscaped(Row row, TestResults testResults) throws Exception {
        try {
            CalledMethodTarget target = this.findMethodFromRow(row, 1, 2);
            Object result = target.invokeForSpecial(row.rowFrom(2), testResults, true, row.cell(0));
            row.addCell(Fixture.escape(target.getResultString(result))).shown();
            CallManager.addShow(row);
        }
        catch (IgnoredException ignoredException) {
            // empty catch block
        }
    }

    public void set(Row row, TestResults testResults) throws Exception {
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("set");
        }
        try {
            if (row.text(2, this).equals("=")) {
                this.setDynamicVariable(row.text(1, this), Ognl.getValue((String)row.text(3, this), null));
                return;
            }
            Object result = this.findMethodFromRow(row, 2, less).invokeForSpecial(row.rowFrom(3), testResults, true, row.cell(0));
            this.setDynamicVariable(row.text(1, this), result);
        }
        catch (IgnoredException e) {
            // empty catch block
        }
    }

    public void showDot(Row row, TestResults testResults) throws Exception {
        GraphicParser adapter = new GraphicParser(new NonGenericTyped(ObjectDotGraphic.class));
        try {
            Object result = this.callMethodInRow(row, testResults, true, row.cell(0));
            row.addCell(adapter.show(new ObjectDotGraphic(result)));
        }
        catch (IgnoredException e) {
            // empty catch block
        }
    }

    public void ensure(Row row, TestResults testResults) throws Exception {
        this.expectedResult = new Boolean(true);
        try {
            Object result = this.callMethodInRow(row, testResults, true, row.cell(0));
            Boolean resultBoolean = result == null ? Boolean.TRUE : (Boolean)result;
            row.cell(0).passOrFail(testResults, resultBoolean);
        }
        catch (IgnoredException e) {
        }
        catch (InvocationTargetException e) {
            Throwable embedded = e.getTargetException();
            if (embedded instanceof FitLibraryShowException) {
                row.error(testResults, embedded);
            }
        }
        catch (Exception e) {
            row.cell(0).fail(testResults);
        }
    }

    public void note(Row row, TestResults testResults) throws Exception {
    }

    public void expectedTestResults(Row row, TestResults testResults) throws Exception {
        if (testResults.matches(row.text(1, this), row.text(3, this), row.text(5, this), row.text(7, this))) {
            testResults.clear();
            row.cell(0).pass(testResults);
        } else {
            String results = testResults.toString();
            testResults.clear();
            row.cell(0).fail(testResults, results, this);
        }
    }

    public Object oo(Row row, TestResults testResults) throws Exception {
        if (row.size() < 3) {
            throw new MissingCellsException("DoTraverseOO");
        }
        String object = row.text(1, this);
        Object className = this.getDynamicVariable(object + ".class");
        if (className == null || "".equals(className)) {
            className = object;
        }
        Row macroRow = row.rowFrom(2);
        return new DefinedActionCaller(object, className.toString(), macroRow, this).run(row, testResults);
    }

    public void log(Row row, TestResults testResults) throws Exception {
        try {
            CalledMethodTarget target = this.findMethodFromRow(row, 1, 2);
            Object result = target.invokeForSpecial(row.rowFrom(2), testResults, true, row.cell(0));
            this.logMessage(target.getResultString(result));
        }
        catch (IgnoredException ignoredException) {
            // empty catch block
        }
    }

    public void runPlain(Row row, TestResults testResults) throws Exception {
        PlainText plainText = new PlainText(row, testResults, this);
        plainText.analyse();
    }

    public void optionally(Row row, TestResults testResults) throws Exception {
        try {
            Object result = this.callMethodInRow(row, testResults, true, row.cell(0));
            if (result instanceof Boolean && !((Boolean)result).booleanValue()) {
                row.addCell("false").shown();
                CallManager.addShow(row);
            }
        }
        catch (FitLibraryException e) {
            row.cell(0).error(testResults, e);
        }
        catch (Exception e) {
            row.addCell(PlugBoard.exceptionHandling.exceptionMessage(e)).shown();
            CallManager.addShow(row);
        }
        row.cell(0).pass(testResults);
    }

    public int getTimeout(String name) {
        return this.runtime().getTimeout(name, 1000);
    }

    protected void putTimeout(String name, int timeout) {
        this.runtime().putTimeout(name, timeout);
    }

    public static interface Comparison {
        public boolean compares(Comparable var1, Comparable var2);
    }
}

