/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.exception.AbandonException;
import fitlibrary.exception.FitLibraryShowException;
import fitlibrary.global.PlugBoard;
import fitlibrary.table.Row;
import fitlibrary.traverse.workflow.DoCaller;
import fitlibrary.traverse.workflow.DoTraverseInterpreter;
import fitlibrary.utility.TestResults;
import java.lang.reflect.InvocationTargetException;

public class ActionCaller
extends DoCaller {
    private CalledMethodTarget target;
    private String methodName;

    public ActionCaller(Row row, DoTraverseInterpreter switchSetUp) {
        this.methodName = row.methodNameForCamel(switchSetUp);
        try {
            this.target = switchSetUp.findMethodByActionName(row, row.size() - 1);
        }
        catch (Exception e) {
            this.setProblem(e);
        }
    }

    public boolean isValid() {
        return this.target != null;
    }

    public Object run(Row row, TestResults testResults) throws Exception {
        try {
            Object result = this.target.invokeAndWrap(row.rowFrom(1), testResults);
            if (result instanceof Boolean) {
                this.target.color(row, (Boolean)result, testResults);
            }
            return result;
        }
        catch (AbandonException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable throwable = PlugBoard.exceptionHandling.unwrapThrowable(e);
            if (throwable instanceof FitLibraryShowException) {
                row.cell(0).error(testResults);
            }
            throw e;
        }
    }

    public String ambiguityErrorMessage() {
        return this.methodName + "()";
    }
}

