/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallManager {
    protected static final ThreadLocal<Set<Object>> definedActionCallsInProgress = new ThreadLocal();
    protected static final ThreadLocal<Table> shows = new ThreadLocal();

    public static void startCall(Object call) {
        CallManager.clearShowsIfNoCallsInProgress();
        CallManager.ensureNotInfinite(call);
        CallManager.get().add(call);
    }

    public static void endCall(Object call) {
        CallManager.get().remove(call);
    }

    public static Table getShowsTable() {
        return shows.get();
    }

    private static Set<Object> ensureNotInfinite(Object call) {
        Set<Object> set = CallManager.get();
        if (set.contains(call)) {
            throw new FitLibraryException("Infinite calling of defined actions");
        }
        return set;
    }

    private static Set<Object> get() {
        Set<Object> set = definedActionCallsInProgress.get();
        if (set == null) {
            set = new HashSet<Object>();
            definedActionCallsInProgress.set(set);
        }
        return set;
    }

    public static void addShow(Row row) {
        if (definedActionCallsInProgress.get() == null || definedActionCallsInProgress.get().isEmpty()) {
            return;
        }
        Table showTable = shows.get();
        if (showTable == null) {
            showTable = new Table();
            shows.set(showTable);
        }
        Row copy = row.copy();
        copy.last().shown();
        showTable.addRow(copy);
    }

    private static void clearShowsIfNoCallsInProgress() {
        Set<Object> set = definedActionCallsInProgress.get();
        if (set != null && set.isEmpty()) {
            shows.set(new Table());
        }
    }

    public static boolean readyToShow() {
        return CallManager.hasNoOutstandingCalls() && CallManager.hasShows();
    }

    private static boolean hasShows() {
        Table showsTable = CallManager.getShowsTable();
        return showsTable != null && showsTable.size() > 0;
    }

    private static boolean hasNoOutstandingCalls() {
        return CallManager.get().isEmpty();
    }
}

