/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fitlibrary.definedAction.ParameterSubstitution;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.global.TemporaryPlugBoardForRuntime;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.workflow.DoCaller;
import fitlibrary.traverse.workflow.DoTraverseInterpreter;
import fitlibrary.traverse.workflow.caller.CallManager;
import fitlibrary.utility.TestResults;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinedActionCaller
extends DoCaller {
    private ParameterSubstitution parameterSubstitution;
    private String methodName;
    private DoTraverseInterpreter doTraverse;
    private List<Object> actualArgs = new ArrayList<Object>();

    public DefinedActionCaller(Row row, DoTraverseInterpreter doTraverse) {
        Object objectName;
        this.doTraverse = doTraverse;
        this.methodName = row.methodNameForCamel(doTraverse);
        this.actualArgs = this.actualArgs(row);
        this.parameterSubstitution = TemporaryPlugBoardForRuntime.definedActionsRepository().lookupByCamel(this.methodName, this.actualArgs.size());
        if (this.parameterSubstitution == null && (objectName = doTraverse.getDynamicVariable("this")) != null) {
            Object className = doTraverse.getDynamicVariable(objectName + ".class");
            this.actualArgs.add(0, objectName.toString());
            if (className != null && !"".equals(className)) {
                this.parameterSubstitution = TemporaryPlugBoardForRuntime.definedActionsRepository().lookupByClassByCamel(className.toString(), this.methodName, this.actualArgs.size() - 1, doTraverse.runtime());
            }
        }
    }

    public DefinedActionCaller(String object, String className, Row row, DoTraverseInterpreter doTraverse) {
        this.doTraverse = doTraverse;
        this.methodName = row.methodNameForCamel(doTraverse);
        this.actualArgs.add(object);
        this.actualArgs(row, this.actualArgs);
        this.parameterSubstitution = TemporaryPlugBoardForRuntime.definedActionsRepository().lookupByClassByCamel(className, this.methodName, this.actualArgs.size() - 1, doTraverse.runtime());
        if (this.parameterSubstitution == null) {
            throw new FitLibraryException("Unknown defined action for object of class " + className);
        }
    }

    @Override
    public boolean isValid() {
        return this.parameterSubstitution != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object run(Row row, TestResults testResults) {
        CallManager.startCall(this.parameterSubstitution);
        try {
            Object oldThisValue = this.doTraverse.getDynamicVariable("this");
            if (!this.actualArgs.isEmpty()) {
                this.doTraverse.setDynamicVariable("this", this.actualArgs.get(0));
            }
            Object result = this.processDefinedAction(this.parameterSubstitution.substitute(this.actualArgs, this.doTraverse), row, testResults);
            this.doTraverse.setDynamicVariable("this", oldThisValue);
        }
        finally {
            CallManager.endCall(this.parameterSubstitution);
        }
        if (!this.doTraverse.toExpandDefinedActions() && CallManager.readyToShow() && !testResults.isAbandoned()) {
            row.addCell(new Cell(new Tables(CallManager.getShowsTable())));
        }
        return null;
    }

    @Override
    public String ambiguityErrorMessage() {
        return "defined action " + this.methodName;
    }

    private List<Object> actualArgs(Row row) {
        return this.actualArgs(row, new ArrayList<Object>());
    }

    private List<Object> actualArgs(Row row, List<Object> result) {
        for (int i = 1; i < row.size(); i += 2) {
            Cell cell = row.cell(i);
            if (cell.hasEmbeddedTable()) {
                result.add(cell.getEmbeddedTables());
                continue;
            }
            result.add(cell.text(this.doTraverse));
        }
        return result;
    }

    private Object processDefinedAction(Tables definedActionBody, Row row, TestResults testResults) {
        Object lastResult = null;
        TestResults subTestResults = new TestResults(testResults);
        for (int i = 0; i < definedActionBody.size(); ++i) {
            Table table = definedActionBody.table(i);
            if (testResults.isAbandoned()) {
                table.ignore(subTestResults);
                lastResult = null;
                continue;
            }
            lastResult = this.doTraverse.interpretWholeTable(table, subTestResults);
        }
        this.colourReport(definedActionBody, row, testResults, subTestResults);
        return lastResult;
    }

    private void colourReport(Tables body, Row row, TestResults testResults, TestResults subTestResults) {
        if (this.doTraverse.toExpandDefinedActions() || subTestResults.problems() || testResults.isAbandoned()) {
            if (!testResults.isAbandoned()) {
                if (subTestResults.passed()) {
                    row.passKeywords(testResults);
                } else if (subTestResults.errors()) {
                    for (int i = 0; i < row.size(); i += 2) {
                        row.cell(i).error(testResults, new FitLibraryException(""));
                    }
                } else if (subTestResults.failed()) {
                    for (int i = 0; i < row.size(); i += 2) {
                        row.cell(i).fail(testResults);
                    }
                } else {
                    for (int i = 0; i < row.size(); i += 2) {
                        row.cell(i).ignore(testResults);
                    }
                }
            }
            row.addCell(new Cell("Defined action call:", body));
        } else if (!testResults.isAbandoned()) {
            row.passKeywords(testResults);
        }
    }
}

