/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fitlibrary.definedAction.MultiParameterSubstitution;
import fitlibrary.global.TemporaryPlugBoardForRuntime;
import fitlibrary.table.Row;
import fitlibrary.traverse.workflow.DoCaller;
import fitlibrary.traverse.workflow.DoTraverseInterpreter;
import fitlibrary.traverse.workflow.caller.MultiDefinedActionTraverse;
import fitlibrary.utility.TestResults;

public class MultiDefinedActionCaller
extends DoCaller {
    private final DoTraverseInterpreter doTraverse;
    private final String methodName;
    private final MultiParameterSubstitution multiParameterSubstitution;
    private final boolean furtherRows;

    public MultiDefinedActionCaller(Row row, DoTraverseInterpreter doTraverse) {
        this.doTraverse = doTraverse;
        this.furtherRows = row.hasFurtherRows();
        this.methodName = row.text(0, doTraverse);
        this.multiParameterSubstitution = TemporaryPlugBoardForRuntime.definedActionsRepository().lookupMulti(this.methodName);
    }

    public String ambiguityErrorMessage() {
        return "multi defined action " + this.methodName;
    }

    public boolean isValid() {
        return this.furtherRows && this.multiParameterSubstitution != null;
    }

    public Object run(Row row, TestResults testResults) throws Exception {
        return new MultiDefinedActionTraverse(this.multiParameterSubstitution, this.doTraverse);
    }
}

