/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fitlibrary.definedAction.MultiParameterSubstitution;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Traverse;
import fitlibrary.traverse.workflow.DoTraverseInterpreter;
import fitlibrary.traverse.workflow.caller.CallManager;
import fitlibrary.utility.TestResults;

public class MultiDefinedActionTraverse
extends Traverse {
    private MultiParameterSubstitution multiParameterSubstitution;
    private DoTraverseInterpreter doTraverse;

    public MultiDefinedActionTraverse(MultiParameterSubstitution multiParameterSubstitution, DoTraverseInterpreter doTraverse) {
        this.multiParameterSubstitution = multiParameterSubstitution;
        this.doTraverse = doTraverse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        if (table.size() < 3) {
            throw new FitLibraryException("Missing data rows in table");
        }
        this.runtime().pushLocal();
        Row parameterRow = table.row(1);
        this.multiParameterSubstitution.verifyParameters(parameterRow, this);
        parameterRow.pass(testResults);
        for (int r = 2; r < table.size(); ++r) {
            Row row = table.row(r);
            if (testResults.isAbandoned()) {
                row.ignore(testResults);
                continue;
            }
            try {
                Tables body = this.multiParameterSubstitution.getCopyOfBody();
                TestResults subTestResults = new TestResults(testResults);
                try {
                    CallManager.startCall(this.multiParameterSubstitution);
                    this.multiParameterSubstitution.bind(parameterRow, row, this.getDynamicVariables(), this);
                    this.runBody(body, testResults, subTestResults);
                    this.colourReport(row, testResults, subTestResults);
                }
                finally {
                    CallManager.endCall(this.multiParameterSubstitution);
                }
                if (this.doTraverse.toExpandDefinedActions() || subTestResults.problems() || testResults.isAbandoned()) {
                    row.addCell(new Cell("Defined action call:", body));
                    continue;
                }
                if (!CallManager.readyToShow()) continue;
                row.addCell(new Cell(new Tables(CallManager.getShowsTable())));
                continue;
            }
            catch (Exception e) {
                row.error(testResults, e);
            }
        }
        this.runtime().popLocal();
        return null;
    }

    private void runBody(Tables body, TestResults testResults, TestResults subTestResults) {
        for (int t = 0; t < body.size(); ++t) {
            Table table = body.table(t);
            if (testResults.isAbandoned()) {
                table.ignore(subTestResults);
                continue;
            }
            this.doTraverse.interpretWholeTable(table, subTestResults);
        }
    }

    private void colourReport(Row row, TestResults testResults, TestResults subTestResults) {
        if (testResults.isAbandoned()) {
            row.ignore(testResults);
        } else if (this.doTraverse.toExpandDefinedActions() || subTestResults.problems()) {
            if (subTestResults.passed()) {
                row.passKeywords(testResults);
            } else if (subTestResults.errors()) {
                for (int i = 0; i < row.size(); ++i) {
                    row.cell(i).error(testResults, new FitLibraryException(""));
                }
            } else if (subTestResults.failed()) {
                for (int i = 0; i < row.size(); ++i) {
                    row.cell(i).fail(testResults);
                }
            } else {
                for (int i = 0; i < row.size(); ++i) {
                    row.cell(i).pass(testResults);
                }
            }
        } else {
            row.pass(testResults);
        }
    }
}

