/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.utility;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.utility.FileAccess;
import fitlibrary.utility.HtmlReceiver;
import fitlibrary.utility.NullIterator;
import fitlibrary.utility.ParseUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWikiTranslator {
    private final FileAccess fileAccess;

    public SimpleWikiTranslator(FileAccess fileAccess) {
        this.fileAccess = fileAccess;
    }

    public void translate(HtmlReceiver receiver) {
        Iterator<File> files = this.fileAccess.filesWithSuffix("txt");
        while (files.hasNext()) {
            File file = files.next();
            SimpleWikiTranslator.translateLines(file, this.fileAccess.linesOf(file), receiver);
        }
    }

    public static String translate(String wiki) {
        final StringBuilder result = new StringBuilder();
        HtmlReceiver accumulatingReceiver = new HtmlReceiver(){

            public void take(File file, String html) {
                result.append(html);
            }
        };
        NullIterator<String> lines = new NullIterator<String>(Arrays.asList(wiki.split("\n")).iterator());
        SimpleWikiTranslator.translateLines(new File(""), lines, accumulatingReceiver);
        return result.toString();
    }

    private static void translateLines(File file, NullIterator<String> lines, HtmlReceiver receiver) {
        StringBuilder result = new StringBuilder("<html>\n<br/>");
        String line = lines.next();
        while (!lines.end(line = SimpleWikiTranslator.processText(line, lines, result)) && !lines.end(line = SimpleWikiTranslator.processTable(line, lines, result))) {
        }
        result.append("</html>");
        receiver.take(file, ParseUtility.tabulize(result.toString()));
    }

    private static String processText(String lineOriginal, NullIterator<String> lines, StringBuilder result) {
        String line = lineOriginal;
        while (!lines.end(line)) {
            if (line.startsWith("!")) {
                line = line.substring(1);
            }
            if (!line.startsWith("#")) {
                if (line.startsWith("|!contents|")) {
                    result.append("<br/>\n");
                } else {
                    if (line.startsWith("|")) {
                        return line;
                    }
                    if (line.startsWith("----")) {
                        result.append("<hr/>\n");
                    } else {
                        result.append(SimpleWikiTranslator.clearWikiJunk(line) + "<br/>\n");
                    }
                }
            }
            line = lines.next();
        }
        return line;
    }

    private static String clearWikiJunk(String lineOriginal) {
        return lineOriginal.replaceAll("'''", "").replaceAll("''", "").replaceAll("!-", "").replaceAll("-!", "");
    }

    private static String processTable(String lineOriginal, NullIterator<String> lines, StringBuilder result) {
        String line = lineOriginal;
        result.append("<table>\n");
        while (!lines.end(line) && line.startsWith("|")) {
            result.append("<tr>");
            List<String> cells = SimpleWikiTranslator.split(line);
            for (String cell : cells) {
                result.append("<td>" + SimpleWikiTranslator.clearWikiJunk(cell) + "</td>");
            }
            result.append("</tr>\n");
            line = lines.next();
        }
        result.append("</table>\n<br/>");
        return line;
    }

    public static List<String> split(String s) {
        int bar;
        ArrayList<String> result = new ArrayList<String>();
        int lastBar = 1;
        while ((bar = s.indexOf("|", lastBar)) >= 0) {
            int escape;
            int lastEscape = lastBar;
            while ((escape = s.indexOf("!-", lastEscape)) >= 0 && escape <= bar) {
                int endEscape = s.indexOf("-!", escape);
                if (endEscape < 0) {
                    throw new FitLibraryException("Missing -!");
                }
                lastEscape = endEscape;
                bar = s.indexOf("|", endEscape);
            }
            if (bar == lastBar) {
                result.add("");
            } else {
                result.add(s.substring(lastBar, bar).trim());
            }
            lastBar = bar + 1;
        }
        return result;
    }
}

