/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.utility;

import fit.Counts;
import fit.FixtureListener;
import fit.Parse;
import fitlibrary.table.Table;
import fitlibrary.utility.TestResults;

public class TableListener {
    private FixtureListener listener;
    private TestResults testResults;

    public TableListener() {
        this(new EmptyFixtureListener(), TestResults.create(new Counts()));
    }

    public TableListener(TestResults testResults) {
        this(new EmptyFixtureListener(), testResults);
    }

    public TableListener(FixtureListener listener) {
        this(listener, TestResults.create(new Counts()));
    }

    public TableListener(FixtureListener listener, TestResults testResults) {
        this.listener = listener;
        this.testResults = testResults;
    }

    public void tableFinished(Table table) {
        this.testResults.addAccumulatedFoldingText(table);
        this.listener.tableFinished(table.parse);
    }

    public FixtureListener getListener() {
        return this.listener;
    }

    public void storytestFinished() {
        this.listener.tablesFinished(this.testResults.getCounts());
    }

    public TestResults getTestResults() {
        return this.testResults;
    }

    public void clearTestResults() {
        this.testResults.clear();
    }

    public static class EmptyFixtureListener
    implements FixtureListener {
        public void tableFinished(Parse table) {
        }

        public void tablesFinished(Counts count) {
        }
    }
}

