/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.utility;

import fit.Counts;
import fitlibrary.table.Table;

public class TestResults {
    public static final String PASS_COLOUR = "#cfffcf";
    public static final String FAIL_COLOUR = "#ffcfcf";
    public static final String IGNORE_COLOR = "#efefef";
    public static final String ERROR_COLOUR = "#ffffcf";
    private Counts counts = new Counts();
    private String foldingText = "";
    private boolean abandoned = false;
    private boolean stopOnError = false;
    private TestResults parent = null;
    private boolean suiteFixtureSoDoNotTearDown = false;
    private static ThreadLocal<TestResults> testResultsByThread = new ThreadLocal();

    public static TestResults create(Counts counts) {
        TestResults testResults = new TestResults(counts);
        testResultsByThread.set(testResults);
        return testResults;
    }

    public static void logAfterTable(String s) {
        TestResults.getThreadLocalVersion().foldingText = TestResults.getThreadLocalVersion().foldingText + s;
    }

    private static TestResults getThreadLocalVersion() {
        TestResults testResults = testResultsByThread.get();
        if (testResults == null) {
            throw new RuntimeException("ThreadLocal is not working");
        }
        return testResults;
    }

    private TestResults(Counts counts) {
        this.counts = counts;
    }

    public TestResults() {
    }

    public TestResults(TestResults testResults) {
        this.parent = testResults;
    }

    public void pass() {
        ++this.counts.right;
    }

    public void fail() {
        ++this.counts.wrong;
        if (this.isStopOnError()) {
            TestResults.setAbandoned();
        }
    }

    public void exception() {
        ++this.counts.exceptions;
        if (this.isStopOnError()) {
            TestResults.setAbandoned();
        }
    }

    public void ignore() {
        ++this.counts.ignores;
    }

    public void clear() {
        this.counts.right = 0;
        this.counts.wrong = 0;
        this.counts.ignores = 0;
        this.counts.exceptions = 0;
        this.abandoned = false;
    }

    public void add(TestResults otherResults) {
        this.counts.tally(otherResults.counts);
        this.abandoned = this.abandoned || otherResults.abandoned;
    }

    public boolean passed() {
        return this.counts.right > 0 && this.counts.wrong == 0 & this.counts.exceptions == 0;
    }

    public boolean failed() {
        return this.counts.wrong > 0;
    }

    public boolean errors() {
        return this.counts.exceptions > 0;
    }

    public boolean problems() {
        return this.counts.wrong + this.counts.exceptions > 0;
    }

    public String toString() {
        return this.counts.toString();
    }

    public boolean matches(String rights, String wrongs, String ignores, String exceptions) {
        return this.cellValue(rights) == this.counts.right && this.cellValue(wrongs) == this.counts.wrong && this.cellValue(ignores) == this.counts.ignores && this.cellValue(exceptions) == this.counts.exceptions;
    }

    private int cellValue(String s) {
        return Integer.parseInt(s);
    }

    public Counts getCounts() {
        return this.counts;
    }

    public String asHtmlTable() {
        String colour = IGNORE_COLOR;
        if (this.passed()) {
            colour = PASS_COLOUR;
        } else if (this.problems()) {
            colour = this.counts.exceptions > 0 ? ERROR_COLOUR : FAIL_COLOUR;
        }
        return "<html><table><tr><td " + TestResults.backgroundColour(colour) + ">" + this.counts.toString() + "</td></tr></table><html>";
    }

    public static String replaceCss(String html) {
        String result = html;
        result = result.replaceAll("class=\"pass\"", TestResults.backgroundColour(PASS_COLOUR));
        result = result.replaceAll("class=\"fail\"", TestResults.backgroundColour(FAIL_COLOUR));
        result = result.replaceAll("class=\"ignore\"", TestResults.backgroundColour(IGNORE_COLOR));
        result = result.replaceAll("class=\"error\"", TestResults.backgroundColour(ERROR_COLOUR));
        return result;
    }

    private static String backgroundColour(String colour) {
        return "bgcolor=\"" + colour + "\"";
    }

    public void addAccumulatedFoldingText(Table table) {
        table.addFoldingText(this.foldingText);
        this.foldingText = "";
    }

    public static void setAbandoned() {
        TestResults.getThreadLocalVersion().abandoned = true;
    }

    public boolean isAbandoned() {
        if (this.parent != null) {
            return this.parent.isAbandoned();
        }
        return this.abandoned;
    }

    public static void setStopOnError(boolean stopOnError) {
        TestResults.getThreadLocalVersion().stopOnError = stopOnError;
    }

    public boolean isStopOnError() {
        if (this.parent != null) {
            return this.parent.isStopOnError();
        }
        return this.stopOnError;
    }

    public void setSuiteFixtureSoDoNotTearDown(boolean suiteFixtureSoDoNotTearDown) {
        this.suiteFixtureSoDoNotTearDown = suiteFixtureSoDoNotTearDown;
    }

    public boolean inSuiteFixtureSoDoNotTearDown() {
        if (this.parent != null) {
            return this.parent.inSuiteFixtureSoDoNotTearDown();
        }
        return this.suiteFixtureSoDoNotTearDown;
    }
}

