/*
 * Decompiled with CFR 0.152.
 */
package fitlibraryGeneric.generic;

import fitlibrary.exception.FitLibraryException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTypeUtility {
    public static GenericCases typeCases(Type type) {
        if (type instanceof ParameterizedType) {
            return GenericCases.PARAMETERIZED_TYPE;
        }
        if (type instanceof TypeVariable) {
            return GenericCases.TYPE_VARIABLE;
        }
        if (type instanceof GenericArrayType) {
            return GenericCases.GENERIC_ARRAY;
        }
        if (type instanceof WildcardType) {
            return GenericCases.WILDCARD_TYPE;
        }
        return GenericCases.CLASS_TYPE;
    }

    public static Class<?> getClassType(Type type) {
        switch (GenericTypeUtility.typeCases(type)) {
            case CLASS_TYPE: {
                return GenericTypeUtility.asClass(type);
            }
            case PARAMETERIZED_TYPE: {
                return GenericTypeUtility.getClassType(GenericTypeUtility.asParameterizedType(type).getRawType());
            }
            case GENERIC_ARRAY: {
                return GenericTypeUtility.asClass((GenericArrayType)type);
            }
            case TYPE_VARIABLE: 
            case WILDCARD_TYPE: {
                throw new RuntimeException("Unable to deal with type " + type + " of " + type.getClass());
            }
        }
        throw new RuntimeException("Unable to deal with type " + type);
    }

    public static Class<?> asClass(GenericArrayType type) {
        try {
            return Array.newInstance(GenericTypeUtility.getClassType(type.getGenericComponentType()), 0).getClass();
        }
        catch (ClassCastException e) {
            throw new FitLibraryException("Unable to deal with unbound type " + type);
        }
    }

    public static String toString(Type type) {
        if (type == null) {
            throw new RuntimeException("Type is null");
        }
        return type.toString();
    }

    public static GenericArrayType asGenericArrayType(Type type) {
        return (GenericArrayType)type;
    }

    public static ParameterizedType asParameterizedType(Type type) {
        return (ParameterizedType)type;
    }

    public static TypeVariable<?> asTypeVariable(Type type) {
        return (TypeVariable)type;
    }

    public static WildcardType asWildcardType(Type type) {
        return (WildcardType)type;
    }

    public static Class<?> asClass(Type type) {
        return (Class)type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GenericCases {
        GENERIC_ARRAY,
        PARAMETERIZED_TYPE,
        TYPE_VARIABLE,
        WILDCARD_TYPE,
        CLASS_TYPE;

    }
}

