/*
 * Decompiled with CFR 0.152.
 */
package fitlibraryGeneric.list;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.classes.NoNullaryConstructor;
import fitlibrary.exception.classes.NotSubclassFromClassFactoryMethod;
import fitlibrary.exception.classes.NullFromClassFactoryMethod;
import fitlibrary.global.PlugBoard;
import fitlibrary.object.DomainObjectSetUpTraverse;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Traverse;
import fitlibrary.traverse.workflow.DoTraverse;
import fitlibrary.utility.ClassUtility;
import fitlibrary.utility.TestResults;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSetUpTraverse2
extends DoTraverse {
    private final Class<?> componentType;
    private CalledMethodTarget[] targets;
    private List<Object> list = new ArrayList<Object>();

    public ListSetUpTraverse2(Class<?> componentType) {
        this.componentType = componentType;
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        try {
            Row firstRow = table.row(0);
            int classColumn = this.findClassColumn(firstRow);
            if (classColumn < 0) {
                Object element = ClassUtility.createElement(this.componentType, this);
                this.bindFirstRowToTargetsForObject(element, firstRow, firstRow, testResults);
            }
            for (int rowNo = 1; rowNo < table.size(); ++rowNo) {
                this.processRow(firstRow, classColumn, table.row(rowNo), testResults);
            }
        }
        catch (IgnoredException e) {
        }
        catch (NoSuchMethodException e) {
            table.error(testResults, (Throwable)new NoNullaryConstructor(this.componentType));
        }
        catch (Exception e) {
            table.error(testResults, (Throwable)e);
        }
        return this.list;
    }

    private int findClassColumn(Row row) {
        for (int cellNo = 0; cellNo < row.size(); ++cellNo) {
            Cell cell = row.cell(cellNo);
            if (!DomainObjectSetUpTraverse.givesClass(cell, this)) continue;
            return cellNo;
        }
        return -1;
    }

    private void bindFirstRowToTargetsForObject(Object element, Row firstRow, Row row, TestResults testResults) {
        this.setSystemUnderTest(element);
        this.targets = new CalledMethodTarget[firstRow.size()];
        for (int i = 0; i < firstRow.size(); ++i) {
            Cell cell = firstRow.cell(i);
            if (DomainObjectSetUpTraverse.givesClass(cell, this)) continue;
            try {
                this.targets[i] = PlugBoard.lookupTarget.findSetter(cell.text(this), this);
                continue;
            }
            catch (Exception e) {
                row.cell(i).error(testResults, e);
            }
        }
    }

    private void processRow(Row firstRow, int classColumn, Row row, TestResults testResults) throws Exception {
        Object element = this.createElement(firstRow, classColumn, row, testResults);
        this.setSystemUnderTest(element);
        this.callStartCreatingObjectMethod(element);
        this.list.add(element);
        for (int i = 0; i < row.size(); ++i) {
            if (i == classColumn || this.targets[i] == null) continue;
            this.targets[i].setTypedSubject(Traverse.asTypedObject(element));
            Cell cell = row.cell(i);
            try {
                this.targets[i].invoke(cell, testResults);
                continue;
            }
            catch (Exception e) {
                cell.error(testResults, e);
            }
        }
        this.callEndCreatingObjectMethod(element);
    }

    private Object createElement(Row firstRow, int classColumn, Row row, TestResults testResults) throws Exception {
        if (classColumn < 0) {
            return ClassUtility.createElement(this.componentType, this);
        }
        String typeName = row.text(classColumn, this);
        Class<?> findClass = PlugBoard.lookupTarget.findClassFromFactoryMethod(this, this.componentType, typeName);
        if (findClass == null) {
            throw new NullFromClassFactoryMethod(typeName);
        }
        if (!this.componentType.isAssignableFrom(findClass)) {
            throw new NotSubclassFromClassFactoryMethod(findClass, this.componentType);
        }
        try {
            Object sut = ClassUtility.createElement(findClass, this);
            this.bindFirstRowToTargetsForObject(sut, firstRow, row, testResults);
            return sut;
        }
        catch (NoSuchMethodException e) {
            row.error(testResults, new NoNullaryConstructor(findClass));
            throw new IgnoredException();
        }
        catch (Exception e) {
            row.cell(0).error(testResults, e);
            throw new IgnoredException();
        }
    }

    public List<Object> getResults() {
        return this.list;
    }
}

