/*
 * Decompiled with CFR 0.152.
 */
package fitlibraryGeneric.list;

import fitlibrary.exception.table.RowWrongWidthException;
import fitlibrary.parser.Parser;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.TestResults;
import fitlibraryGeneric.typed.GenericTyped;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestingListTraverse
extends Traverse {
    private List<Object> list;
    private GenericTyped typed;

    public NestingListTraverse(List<Object> list, GenericTyped type) {
        this.list = list;
        this.typed = type;
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        Cell cell;
        Row row;
        Parser parser = this.typed.parser(this);
        for (int rowNo = 0; rowNo < table.size(); ++rowNo) {
            row = table.row(rowNo);
            try {
                if (row.size() != 1) {
                    throw new RowWrongWidthException(1);
                }
                cell = row.cell(0);
                if (this.list.size() > rowNo) {
                    parser.matches(cell, this.list.get(rowNo), testResults);
                    continue;
                }
                cell.actualElementMissing(testResults);
                continue;
            }
            catch (Exception e) {
                row.error(testResults, e);
            }
        }
        for (int i = table.size(); i < this.list.size(); ++i) {
            row = table.newRow();
            cell = row.addCell();
            try {
                cell.actualElementMissing(testResults, parser.show(this.list.get(i)));
                continue;
            }
            catch (Exception e) {
                cell.error(testResults, e);
            }
        }
        return this.list;
    }
}

