/*
 * Decompiled with CFR 0.152.
 */
package fitlibraryGeneric.object;

import fitlibrary.closure.Closure;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.global.PlugBoard;
import fitlibrary.object.Finder;
import fitlibrary.ref.EntityReference;
import fitlibrary.traverse.Evaluator;
import fitlibrary.utility.ExtendedCamelCase;
import fitlibraryGeneric.typed.GenericTyped;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;

public class GenericFinder
implements Finder {
    public static final String FIND = "find";
    public static final String SHOW = "show";
    private GenericTyped typed;
    private String findExceptionMessage;
    private Closure findIntMethod;
    private Closure findStringMethod;
    private Closure showMethod;
    private Closure genericFindStringMethod;
    private Closure genericShowMethod;
    private EntityReference referenceParser;

    public GenericFinder(GenericTyped typed, Evaluator evaluator) {
        this.typed = typed;
        String shortClassName = typed.simpleClassName();
        this.referenceParser = EntityReference.create(shortClassName.toLowerCase());
        Class[] intArg = new Class[]{Integer.TYPE};
        Class[] stringArg = new Class[]{String.class};
        Class[] showArg = new Class[]{typed.asClass()};
        String findName = ExtendedCamelCase.camel("find " + shortClassName);
        String findMethodSignature = "public " + shortClassName + " find" + shortClassName + "(String key) { } ";
        String genericFindMethodSignature = "public " + shortClassName + " find" + shortClassName + "(String key, Type type) { } ";
        String showMethodName = ExtendedCamelCase.camel("show " + shortClassName);
        String potentialClasses = PlugBoard.lookupTarget.identifiedClassesInOutermostContext(evaluator, true);
        this.findExceptionMessage = "EITHER " + shortClassName + " is (1) a Value Object. So missing parse method: " + "public static " + shortClassName + " parse(String s) { } in class " + typed.getClassName() + "; OR (2) an Entity. So missing finder method: " + findMethodSignature;
        if (typed.isGeneric()) {
            this.findExceptionMessage = this.findExceptionMessage + " or missing generic finder method: " + genericFindMethodSignature;
        }
        this.findExceptionMessage = this.findExceptionMessage + "in " + potentialClasses;
        this.findIntMethod = PlugBoard.lookupTarget.findFixturingMethod(evaluator, findName, intArg);
        this.findStringMethod = PlugBoard.lookupTarget.findFixturingMethod(evaluator, findName, stringArg);
        this.showMethod = PlugBoard.lookupTarget.findFixturingMethod(evaluator, showMethodName, showArg);
        if (typed.isGeneric()) {
            Class[] genericStringArg = new Class[]{String.class, Type.class};
            Class[] genericShowArg = new Class[]{typed.asClass(), Type.class};
            this.genericFindStringMethod = PlugBoard.lookupTarget.findFixturingMethod(evaluator, findName, genericStringArg);
            this.genericShowMethod = PlugBoard.lookupTarget.findFixturingMethod(evaluator, showMethodName, genericShowArg);
        }
    }

    private Object callFindStringMethod(String text) throws Exception {
        if (this.genericFindStringMethod != null) {
            return this.genericFindStringMethod.invoke(new Object[]{text, this.typed.asType()});
        }
        if (this.findStringMethod != null) {
            return this.findStringMethod.invoke(new String[]{text});
        }
        if ("".equals(text)) {
            return null;
        }
        throw new FitLibraryException(this.findExceptionMessage);
    }

    public Object find(String text) throws Exception, IllegalAccessException, InvocationTargetException {
        if (this.findIntMethod != null) {
            int index = 0;
            try {
                index = this.referenceParser.getIndex(text);
            }
            catch (FitLibraryException e) {
                return this.callFindStringMethod(text);
            }
            return this.findIntMethod.invoke(new Integer[]{new Integer(index)});
        }
        return this.callFindStringMethod(text);
    }

    public String show(Object result) throws Exception {
        if (this.genericShowMethod != null) {
            Object[] args = new Object[]{result, this.typed.asType()};
            return this.genericShowMethod.invoke(args).toString();
        }
        if (this.showMethod != null) {
            Object[] args = new Object[]{result};
            return this.showMethod.invoke(args).toString();
        }
        if (result == null) {
            return "";
        }
        return result.toString();
    }

    public boolean hasFinderMethod() {
        return this.findIntMethod != null || this.findStringMethod != null;
    }
}

