/*
 * Decompiled with CFR 0.152.
 */
package fitlibraryGeneric.set;

import fitlibrary.collection.CollectionSetUpTraverse;
import fitlibrary.collection.set.SetTraverse;
import fitlibrary.parser.Parser;
import fitlibrary.parser.collection.SetParser;
import fitlibrary.parser.lookup.ParserFactory;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import fitlibrary.utility.MapElement;
import fitlibrary.utility.TestResults;
import fitlibraryGeneric.list.ListSetUpTraverse2;
import fitlibraryGeneric.list.NestingListSetUpTraverse;
import fitlibraryGeneric.set.NestingSetTraverse;
import fitlibraryGeneric.typed.GenericTyped;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SetParser2
extends SetParser {
    private GenericTyped componentTyped;

    public SetParser2(Evaluator evaluator, GenericTyped generic) {
        super(evaluator, generic);
        this.componentTyped = generic.getComponentTyped();
        generic.assertHasParameters(1);
    }

    protected Object parseTable(Table table, TestResults testResults) {
        switch (this.componentTyped.typeCases()) {
            case CLASS_TYPE: {
                if (this.componentTyped.isArray()) {
                    return this.parseNested(table, testResults);
                }
                if (CollectionSetUpTraverse.hasObjectFactoryMethodFor(table, this.evaluator)) {
                    return super.parseTable(table, testResults);
                }
                ListSetUpTraverse2 setUp = new ListSetUpTraverse2(this.componentTyped.asClass());
                setUp.interpretWithinContext(table, this.evaluator, testResults);
                return new HashSet<Object>(setUp.getResults());
            }
            case PARAMETERIZED_TYPE: {
                return this.parseNested(table, testResults);
            }
        }
        throw new RuntimeException("Type not sufficiently bound: " + this.componentTyped);
    }

    private Object parseNested(Table table, TestResults testResults) {
        NestingListSetUpTraverse nestingSetUp = new NestingListSetUpTraverse(this.componentTyped);
        nestingSetUp.interpretWithinContext(table, this.evaluator, testResults);
        return new HashSet<Object>(nestingSetUp.getResults());
    }

    protected boolean tableMatches(Table table, Object resultInitial, TestResults testResults) {
        HashSet<MapElement> result = resultInitial;
        switch (this.componentTyped.typeCases()) {
            case CLASS_TYPE: {
                if (result instanceof Map) {
                    result = this.keyed(table) ? new HashSet<MapElement>(SetTraverse.mapMapToSet((Map)((Object)result))) : new HashSet(((Map)((Object)result)).values());
                }
                if (!this.componentTyped.isArray()) {
                    SetTraverse setChecking = new SetTraverse((Object)null);
                    setChecking.setActualCollection((Collection<Object>)result);
                    setChecking.setComponentType(this.componentTyped.asClass());
                    return setChecking.doesInnerTablePass(table, this.evaluator, testResults);
                }
            }
            case PARAMETERIZED_TYPE: {
                NestingSetTraverse nestingSet = new NestingSetTraverse((Set<Object>)result, this.componentTyped);
                return nestingSet.doesTablePass(table, this.evaluator, testResults);
            }
        }
        throw new RuntimeException("Type not sufficiently bound: " + this.componentTyped);
    }

    private boolean keyed(Table table) {
        return table.row(0).cellExists(0) && table.row(0).text(0, this.evaluator).toLowerCase().equals("key") || table.row(0).cellExists(1) && table.row(0).text(1, this.evaluator).toLowerCase().equals("key");
    }

    public static ParserFactory parserFactory() {
        return new ParserFactory(){

            public Parser parser(Evaluator evaluator, Typed typed) {
                GenericTyped genericTyped = (GenericTyped)typed;
                if (genericTyped.isGeneric()) {
                    return new SetParser2(evaluator, genericTyped);
                }
                return new SetParser(evaluator, typed);
            }
        };
    }
}

