/*
 * Decompiled with CFR 0.152.
 */
package fitlibraryGeneric.traverse;

import fit.exception.FitFailureException;
import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.method.MissingMethodException;
import fitlibrary.exception.table.MissingCellsException;
import fitlibrary.global.PlugBoard;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.TestResults;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceTraverse
extends Traverse {
    private static String[] WORD_COUNTS = new String[]{"first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eigth", "nineth", "tenth"};
    private static Map<String, Integer> MAP_WORD_TO_INT = new HashMap<String, Integer>();

    public ReferenceTraverse() {
    }

    public ReferenceTraverse(Object sut) {
        super(sut);
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults results) {
        table.error(results, (Throwable)new FitFailureException("Not expected"));
        return null;
    }

    public static boolean applicable(Table table) {
        if (table.size() == 1) {
            return ReferenceTraverse.isUses(table.row(0).cell(0).text());
        }
        return false;
    }

    private static boolean isUses(String text) {
        return text.toLowerCase().equals("use");
    }

    public Object interpretReference(Table table, TestResults testResults) throws Exception {
        return this.getObject(table.row(0), 1, this.getSystemUnderTest(), testResults);
    }

    private Object getObject(Row row, int cellNo, Object initialObject, TestResults testResults) {
        Object object = initialObject;
        boolean last = false;
        if (row.cellExists(cellNo + 1)) {
            Cell nextCell = row.cell(cellNo + 1);
            if (!nextCell.matchesText("of", this) && !nextCell.matchesText("in", this)) {
                nextCell.fail(testResults, "'of' or 'in' expected", this);
                throw new IgnoredException();
            }
            if (!row.cellExists(cellNo + 2)) {
                nextCell.error(testResults, new MissingCellsException(""));
                throw new IgnoredException();
            }
            object = this.getObject(row, cellNo + 2, object, testResults);
        } else {
            last = true;
        }
        return this.getReferencedObject(row.cell(cellNo), object, last, testResults);
    }

    private Object getReferencedObject(Cell cell, Object object, boolean last, TestResults testResults) {
        if (object instanceof List) {
            return this.getElementOfList(cell, (List)object);
        }
        if (object.getClass().isArray()) {
            return this.getElementOfArray(cell, (Object[])object);
        }
        if (object instanceof Map) {
            return this.getElementOfMap(cell, (Map)object, testResults);
        }
        return this.getPropertyOfObject(cell, object, last, testResults);
    }

    private Object getPropertyOfObject(Cell cell, Object object, boolean last, TestResults testResults) {
        try {
            String name = cell.text(this);
            CalledMethodTarget target = this.getGetterTarget(cell, name, object, last, testResults);
            return target.invoke(new Object[0]);
        }
        catch (IgnoredException e) {
            throw e;
        }
        catch (Exception e) {
            cell.error(testResults, e);
            throw new IgnoredException();
        }
    }

    private Object getElementOfMap(Cell cell, Map<String, Object> map, TestResults testResults) {
        Object object = map.get(cell.text(this));
        if (object == null) {
            cell.error(testResults, new FitFailureException("Reference failed"));
            throw new IgnoredException();
        }
        return object;
    }

    private Object getElementOfArray(Cell cell, Object[] objects) {
        Integer index = MAP_WORD_TO_INT.get(cell.textLower(this));
        if (index == null || index < 0 || index >= objects.length) {
            throw new FitFailureException("Reference not defined: '" + cell.textLower(this) + "'");
        }
        return objects[index];
    }

    private Object getElementOfList(Cell cell, List<Object> list) {
        Integer index = MAP_WORD_TO_INT.get(cell.textLower(this));
        if (index == null || index < 0 || index >= list.size()) {
            throw new FitFailureException("Reference not defined: '" + cell.textLower(this) + "'");
        }
        return list.get(index);
    }

    private CalledMethodTarget getGetterTarget(Cell cell, String name, Object sut, boolean considerContext, TestResults testResults) {
        try {
            return PlugBoard.lookupTarget.findGetterUpContextsToo(ReferenceTraverse.asTypedObject(sut), this, name, considerContext);
        }
        catch (MissingMethodException ex) {
            cell.error(testResults, ex);
            throw new IgnoredException();
        }
    }

    static {
        int i = 0;
        for (String word : WORD_COUNTS) {
            MAP_WORD_TO_INT.put(word, i++);
        }
    }
}

