/*
 * Decompiled with CFR 0.152.
 */
package fitlibraryGeneric.typed;

import fitlibrary.parser.lookup.FieldParser;
import fitlibrary.parser.lookup.GetterParser;
import fitlibrary.parser.lookup.ResultParser;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.NonGenericTypedObject;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibraryGeneric.typed.GenericTyped;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTypedObject
extends NonGenericTypedObject {
    private GenericTyped typed;

    public GenericTypedObject(Object subject, GenericTyped typed) {
        super(subject);
        this.typed = typed;
    }

    public GenericTypedObject(Object subject) {
        super(subject);
        this.typed = subject == null ? new GenericTyped(Void.TYPE) : new GenericTyped(subject.getClass());
    }

    @Override
    protected TypedObject asTypedObject(Object sut) {
        return new GenericTypedObject(sut);
    }

    @Override
    public Class<?> getClassType() {
        return this.typed.asClass();
    }

    @Override
    protected Typed resultTyped(Method method) {
        Type genericReturnType = this.typed.bind(method.getGenericReturnType(), this.describe(method));
        return new GenericTyped(genericReturnType, true);
    }

    @Override
    protected Typed resultTyped(Field field) {
        Type genericReturnType = this.typed.bind(field.getGenericType(), this.describe(field));
        return new GenericTyped(genericReturnType, true);
    }

    public GetterParser resultParser(Evaluator evaluator, Method method, Class actualResultType) {
        GenericTyped resultTyped = new GenericTyped(actualResultType, true);
        return new GetterParser(this.typed.on(evaluator, resultTyped, true), method);
    }

    public ResultParser resultParser(Evaluator evaluator, Field field, Class actualResultType) {
        GenericTyped resultTyped = new GenericTyped(actualResultType, true);
        return new FieldParser(this.typed.on(evaluator, resultTyped, true), field);
    }

    @Override
    protected Typed parameterTyped(Method method, int parameterNo) {
        Type givenType = method.getGenericParameterTypes()[parameterNo];
        Type genericParameterType = this.typed.bind(givenType, this.describe(method));
        return new GenericTyped(genericParameterType, true);
    }

    @Override
    public TypedObject asReturnTypedObject(Object object, Method method) {
        return new GenericTypedObject(object, new GenericTyped(this.typed.bind(method.getGenericReturnType(), this.describe(method))));
    }

    @Override
    public TypedObject asReturnTypedObject(Object object, Field field) {
        return new GenericTypedObject(object, new GenericTyped(this.typed.bind(field.getGenericType(), this.describe(field))));
    }

    @Override
    public String toString() {
        return "GenericTypedObject[" + this.subject + ":" + this.typed + "]";
    }

    @Override
    public Typed getTyped() {
        return this.typed;
    }

    private String describe(Method method) {
        return "in " + method.toGenericString();
    }

    private String describe(Field field) {
        return "in " + field.getName();
    }
}

