/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.WikiPageFactory;
import fitnesse.authentication.Authenticator;
import fitnesse.html.HtmlPageFactory;
import fitnesse.responders.ResponderFactory;
import fitnesse.responders.editing.ContentFilter;
import fitnesse.responders.editing.SaveResponder;
import fitnesse.wiki.VersionsController;
import fitnesse.wiki.zip.ZipFileVersionsController;
import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.WidgetInterceptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentFactory {
    private final String endl = System.getProperty("line.separator");
    public static final String PROPERTIES_FILE = "plugins.properties";
    public static final String WIKI_PAGE_CLASS = "WikiPage";
    public static final String HTML_PAGE_FACTORY = "HtmlPageFactory";
    public static final String PLUGINS = "Plugins";
    public static final String RESPONDERS = "Responders";
    public static final String WIKI_WIDGETS = "WikiWidgets";
    public static final String WIKI_WIDGET_INTERCEPTORS = "WikiWidgetInterceptors";
    public static final String AUTHENTICATOR = "Authenticator";
    public static final String CONTENT_FILTER = "ContentFilter";
    public static final String VERSIONS_CONTROLLER = "VersionsController";
    public static final String DEFAULT_NEWPAGE_CONTENT = "newpage.default.content";
    private final Properties loadedProperties;
    private final String propertiesLocation;
    private boolean propertiesAreLoaded = false;

    public ComponentFactory() {
        this(new Properties());
    }

    public ComponentFactory(String propertiesLocation) {
        this(propertiesLocation, new Properties());
    }

    public ComponentFactory(Properties properties) {
        this.propertiesLocation = null;
        this.loadedProperties = properties;
        this.propertiesAreLoaded = true;
    }

    public ComponentFactory(String propertiesLocation, Properties properties) {
        this.propertiesLocation = propertiesLocation;
        this.loadedProperties = properties;
        this.loadProperties(propertiesLocation);
    }

    protected void loadProperties(String propertiesLocation) {
        try {
            String propertiesPath = propertiesLocation + "/" + PROPERTIES_FILE;
            FileInputStream propertiesStream = new FileInputStream(propertiesPath);
            this.loadedProperties.load(propertiesStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    Properties getProperties() {
        if (!this.propertiesAreLoaded) {
            this.loadProperties(this.propertiesLocation);
            this.propertiesAreLoaded = true;
        }
        return this.loadedProperties;
    }

    public String getProperty(String propertyName) {
        return this.getProperties().getProperty(propertyName);
    }

    public Object createComponent(String componentType, Class<?> defaultComponent) throws Exception {
        String componentClassName = this.loadedProperties.getProperty(componentType);
        Class<?> componentClass = componentClassName != null ? Class.forName(componentClassName) : defaultComponent;
        if (componentClass != null) {
            Constructor<?> constructor = componentClass.getConstructor(Properties.class);
            return constructor.newInstance(this.loadedProperties);
        }
        return null;
    }

    public Object createComponent(String componentType) throws Exception {
        return this.createComponent(componentType, null);
    }

    public String loadWikiPage(WikiPageFactory factory) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String rootPageClassName = this.loadedProperties.getProperty(WIKI_PAGE_CLASS);
        if (rootPageClassName != null) {
            factory.setWikiPageClass(Class.forName(rootPageClassName));
            buffer.append("\tCustom wiki page plugin loaded: ").append(rootPageClassName).append(this.endl);
        }
        return buffer.toString();
    }

    public HtmlPageFactory getHtmlPageFactory(HtmlPageFactory defaultPageFactory) throws Exception {
        HtmlPageFactory htmlPageFactory = (HtmlPageFactory)this.createComponent(HTML_PAGE_FACTORY);
        return htmlPageFactory == null ? defaultPageFactory : htmlPageFactory;
    }

    public String loadPlugins(ResponderFactory responderFactory, WikiPageFactory wikiPageFactory) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String[] responderPlugins = this.getListFromProperties(PLUGINS);
        if (responderPlugins != null) {
            buffer.append("\tCustom plugins loaded:").append(this.endl);
            for (String responderPlugin : responderPlugins) {
                Class<?> pluginClass = Class.forName(responderPlugin);
                this.loadWikiPageFromPlugin(pluginClass, wikiPageFactory, buffer);
                this.loadRespondersFromPlugin(pluginClass, responderFactory, buffer);
                this.loadWikiWidgetsFromPlugin(pluginClass, WidgetBuilder.htmlWidgetBuilder, buffer);
            }
        }
        return buffer.toString();
    }

    private void loadWikiPageFromPlugin(Class<?> pluginClass, WikiPageFactory wikiPageFactory, StringBuffer buffer) throws IllegalAccessException, InvocationTargetException {
        try {
            Method method = pluginClass.getMethod("registerWikiPage", WikiPageFactory.class);
            method.invoke(pluginClass, wikiPageFactory);
            buffer.append("\t\t").append("wikiPage:").append(pluginClass.getName()).append(this.endl);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
    }

    private void loadRespondersFromPlugin(Class<?> pluginClass, ResponderFactory responderFactory, StringBuffer buffer) throws IllegalAccessException, InvocationTargetException {
        try {
            Method method = pluginClass.getMethod("registerResponders", ResponderFactory.class);
            method.invoke(pluginClass, responderFactory);
            buffer.append("\t\t").append("responders:").append(pluginClass.getName()).append(this.endl);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
    }

    private void loadWikiWidgetsFromPlugin(Class<?> pluginClass, WidgetBuilder widgetBuilder, StringBuffer buffer) throws IllegalAccessException, InvocationTargetException {
        try {
            Method method = pluginClass.getMethod("registerWikiWidgets", WidgetBuilder.class);
            method.invoke(pluginClass, widgetBuilder);
            buffer.append("\t\t").append("widgets:").append(pluginClass.getName()).append(this.endl);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
    }

    public String loadResponders(ResponderFactory responderFactory) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String[] responderList = this.getListFromProperties(RESPONDERS);
        if (responderList != null) {
            buffer.append("\tCustom responders loaded:").append(this.endl);
            for (String responder : responderList) {
                String[] values = responder.trim().split(":");
                String key = values[0];
                String className = values[1];
                responderFactory.addResponder(key, className);
                buffer.append("\t\t").append(key).append(":").append(className).append(this.endl);
            }
        }
        return buffer.toString();
    }

    private String[] getListFromProperties(String propertyName) {
        String value = this.loadedProperties.getProperty(propertyName);
        if (value == null) {
            return null;
        }
        return value.split(",");
    }

    public Authenticator getAuthenticator(Authenticator defaultAuthenticator) throws Exception {
        Authenticator authenticator = (Authenticator)this.createComponent(AUTHENTICATOR);
        return authenticator == null ? defaultAuthenticator : authenticator;
    }

    public String loadWikiWidgets() throws Exception {
        StringBuffer buffer = new StringBuffer();
        String[] widgetNames = this.getListFromProperties(WIKI_WIDGETS);
        if (widgetNames != null) {
            buffer.append("\tCustom wiki widgets loaded:").append(this.endl);
            for (String widgetName : widgetNames) {
                Class<?> widgetClass = Class.forName(widgetName.trim());
                WidgetBuilder.htmlWidgetBuilder.addWidgetClass(widgetClass);
                buffer.append("\t\t").append(widgetClass.getName()).append(this.endl);
            }
        }
        return buffer.toString();
    }

    public String loadWikiWidgetInterceptors() throws Exception {
        StringBuffer buffer = new StringBuffer();
        String[] widgetInterceptorList = this.getListFromProperties(WIKI_WIDGET_INTERCEPTORS);
        if (widgetInterceptorList != null) {
            buffer.append("\tCustom wiki widget interceptors loaded:").append(this.endl);
            for (String interceptorClass : widgetInterceptorList) {
                WidgetBuilder.htmlWidgetBuilder.addInterceptor((WidgetInterceptor)Class.forName(interceptorClass).newInstance());
                buffer.append("\t\t").append(interceptorClass).append(this.endl);
            }
        }
        return buffer.toString();
    }

    public String loadContentFilter() throws Exception {
        ContentFilter filter = (ContentFilter)this.createComponent(CONTENT_FILTER);
        if (filter != null) {
            SaveResponder.contentFilter = filter;
            return "\tContent filter installed: " + filter.getClass().getName() + "\n";
        }
        return "";
    }

    public VersionsController loadVersionsController() throws Exception {
        VersionsController versionsController = (VersionsController)this.createComponent(VERSIONS_CONTROLLER);
        if (versionsController == null) {
            versionsController = new ZipFileVersionsController();
        }
        return versionsController;
    }
}

