/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.FitNesse;
import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.components.LogData;
import fitnesse.http.HttpException;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.responders.ErrorResponder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.GregorianCalendar;
import util.StringUtil;

public class FitNesseExpediter
implements ResponseSender {
    private Socket socket;
    private InputStream input;
    private OutputStream output;
    private Request request;
    private Response response;
    private FitNesseContext context;
    protected long requestParsingTimeLimit;
    private long requestProgress;
    private long requestParsingDeadline;
    private volatile boolean hasError;

    public FitNesseExpediter(Socket s, FitNesseContext context) throws Exception {
        this.context = context;
        this.socket = s;
        this.input = s.getInputStream();
        this.output = s.getOutputStream();
        this.requestParsingTimeLimit = 10000L;
    }

    public void start() throws Exception {
        try {
            Request request = this.makeRequest();
            this.makeResponse(request);
            this.sendResponse();
        }
        catch (SocketException se) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void setRequestParsingTimeLimit(long t) {
        this.requestParsingTimeLimit = t;
    }

    public long getRequestParsingTimeLimit() {
        return this.requestParsingTimeLimit;
    }

    public void send(byte[] bytes) throws Exception {
        try {
            this.output.write(bytes);
            this.output.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() throws Exception {
        try {
            this.log(this.socket, this.request, this.response);
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Socket getSocket() throws Exception {
        return this.socket;
    }

    public Request makeRequest() throws Exception {
        this.request = new Request(this.input);
        return this.request;
    }

    public void sendResponse() throws Exception {
        this.response.readyToSend(this);
    }

    private Response makeResponse(Request request) throws Exception {
        try {
            Thread parseThread = this.createParsingThread(request);
            parseThread.start();
            this.waitForRequest(request);
            if (!this.hasError) {
                this.response = this.createGoodResponse(request);
            }
        }
        catch (SocketException se) {
            throw se;
        }
        catch (Exception e) {
            this.response = new ErrorResponder(e).makeResponse(this.context, request);
        }
        return this.response;
    }

    public Response createGoodResponse(Request request) throws Exception {
        if (StringUtil.isBlank(request.getResource()) && StringUtil.isBlank(request.getQueryString())) {
            request.setResource("FrontPage");
        }
        Responder responder = this.context.responderFactory.makeResponder(request, this.context.root);
        responder = this.context.authenticator.authenticate(this.context, request, responder);
        Response response = responder.makeResponse(this.context, request);
        response.addHeader("Server", "FitNesse-" + FitNesse.VERSION);
        response.addHeader("Connection", "close");
        return response;
    }

    private void waitForRequest(Request request) throws InterruptedException {
        long now = System.currentTimeMillis();
        this.requestParsingDeadline = now + this.requestParsingTimeLimit;
        this.requestProgress = 0L;
        while (!this.hasError && !request.hasBeenParsed()) {
            Thread.sleep(10L);
            if (!this.timeIsUp(now) || !this.parsingIsUnproductive(request)) continue;
            this.reportError(408, "The client request has been unproductive for too long.  It has timed out and will now longer be processed");
        }
    }

    private boolean parsingIsUnproductive(Request request) {
        long updatedRequestProgress = request.numberOfBytesParsed();
        if (updatedRequestProgress > this.requestProgress) {
            this.requestProgress = updatedRequestProgress;
            return false;
        }
        return true;
    }

    private boolean timeIsUp(long now) {
        now = System.currentTimeMillis();
        if (now > this.requestParsingDeadline) {
            this.requestParsingDeadline = now + this.requestParsingTimeLimit;
            return true;
        }
        return false;
    }

    private Thread createParsingThread(final Request request) {
        Thread parseThread = new Thread(){

            public synchronized void run() {
                try {
                    request.parse();
                }
                catch (HttpException e) {
                    FitNesseExpediter.this.reportError(400, e.getMessage());
                }
                catch (Exception e) {
                    FitNesseExpediter.this.reportError(e);
                }
            }
        };
        return parseThread;
    }

    private void reportError(int status, String message) {
        try {
            this.response = new ErrorResponder(message).makeResponse(this.context, this.request);
            this.response.setStatus(status);
            this.hasError = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reportError(Exception e) {
        try {
            this.response = new ErrorResponder(e).makeResponse(this.context, this.request);
            this.hasError = true;
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static LogData makeLogData(Socket socket, Request request, Response response) {
        LogData data = new LogData();
        data.host = ((InetSocketAddress)socket.getRemoteSocketAddress()).getAddress().getHostAddress();
        data.time = new GregorianCalendar();
        data.requestLine = request.getRequestLine();
        data.status = response.getStatus();
        data.size = response.getContentSize();
        data.username = request.getAuthorizationUsername();
        return data;
    }

    public void log(Socket s, Request request, Response response) throws Exception {
        if (this.context.logger != null) {
            this.context.logger.log(FitNesseExpediter.makeLogData(s, request, response));
        }
    }
}

