/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.FitNesseContext;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityFactory {
    private VelocityEngine velocityEngine = null;
    private static VelocityFactory instance = null;
    private String rootPath;
    private String rootDirectoryName;

    public static void makeVelocityFactory(FitNesseContext context) {
        if (instance == null) {
            instance = new VelocityFactory(context.rootPath, context.rootDirectoryName);
        }
    }

    public static void setVelocityEngine(VelocityEngine velocityEngine) {
        VelocityFactory.instance.velocityEngine = velocityEngine;
    }

    public VelocityFactory(String rootPath, String rootDirectoryName) {
        this.rootPath = rootPath;
        this.rootDirectoryName = rootDirectoryName;
    }

    public static String translateTemplate(VelocityContext velocityContext, String templateFileName) throws Exception {
        Template template = VelocityFactory.getVelocityEngine().getTemplate(templateFileName);
        StringWriter writer = new StringWriter();
        template.merge((Context)velocityContext, (Writer)writer);
        return writer.toString();
    }

    public static VelocityEngine getVelocityEngine() {
        if (VelocityFactory.instance.velocityEngine == null) {
            VelocityFactory.instance.velocityEngine = new VelocityEngine();
            String templatePath = String.format("%s/%s/files/templates", VelocityFactory.instance.rootPath, VelocityFactory.instance.rootDirectoryName);
            VelocityFactory.instance.velocityEngine.setProperty("file.resource.loader.path", (Object)templatePath);
            try {
                VelocityFactory.instance.velocityEngine.init();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return VelocityFactory.instance.velocityEngine;
    }
}

