/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.PageFinder;
import fitnesse.components.SearchObserver;
import fitnesse.components.TraversalListener;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.WidgetVisitor;
import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.widgets.AliasLinkWidget;
import fitnesse.wikitext.widgets.PreProcessorLiteralWidget;
import fitnesse.wikitext.widgets.PreformattedWidget;
import fitnesse.wikitext.widgets.WidgetRoot;
import fitnesse.wikitext.widgets.WikiWordWidget;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhereUsedPageFinder
implements TraversalListener,
SearchObserver,
WidgetVisitor,
PageFinder {
    private WikiPage subjectPage;
    private SearchObserver observer;
    private WikiPage currentPage;
    private List<WikiPage> hits = new ArrayList<WikiPage>();

    public WhereUsedPageFinder(WikiPage subjectPage, SearchObserver observer) {
        this.subjectPage = subjectPage;
        this.observer = observer;
    }

    @Override
    public void hit(WikiPage referencingPage) throws Exception {
    }

    @Override
    public void visit(WikiWidget widget) throws Exception {
    }

    @Override
    public void visit(WikiWordWidget widget) throws Exception {
        if (this.hits.contains(this.currentPage)) {
            return;
        }
        WikiPage referencedPage = widget.getReferencedPage();
        if (referencedPage != null && referencedPage.equals(this.subjectPage)) {
            this.hits.add(this.currentPage);
            this.observer.hit(this.currentPage);
        }
    }

    @Override
    public void visit(AliasLinkWidget widget) throws Exception {
    }

    @Override
    public void processPage(WikiPage currentPage) throws Exception {
        this.currentPage = currentPage;
        String content = currentPage.getData().getContent();
        WidgetBuilder referenceWidgetBuilder = new WidgetBuilder(PreProcessorLiteralWidget.class, WikiWordWidget.class, PreformattedWidget.class);
        WidgetRoot widgetRoot = new WidgetRoot(content, currentPage, referenceWidgetBuilder);
        widgetRoot.acceptVisitor(this);
    }

    @Override
    public List<WikiPage> search(WikiPage page) throws Exception {
        this.hits.clear();
        this.subjectPage.getPageCrawler().traverse(page, this);
        return this.hits;
    }
}

