/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fit.ColumnFixture;
import fit.Parse;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class RowEntryFixture
extends ColumnFixture {
    public static final String ERROR_INDICATOR = "Unable to enter last row: ";
    public static final String RIGHT_STYLE = "pass";
    public static final String WRONG_STYLE = "fail";

    public abstract void enterRow() throws Exception;

    public void doRow(Parse row) {
        if (row.parts.body.indexOf(ERROR_INDICATOR) != -1) {
            return;
        }
        super.doRow(row);
        try {
            this.enterRow();
            this.right(this.appendCell(row, "entered"));
        }
        catch (Exception e) {
            this.wrong(this.appendCell(row, "skipped"));
            this.reportError(row, e);
        }
    }

    protected Parse appendCell(Parse row, String text) {
        Parse lastCell;
        row.parts.last().more = lastCell = new Parse("td", text, null, null);
        return lastCell;
    }

    public void reportError(Parse row, Exception e) {
        Parse errorCell = this.makeMessageCell(e);
        this.insertRowAfter(row, new Parse("tr", null, errorCell, null));
    }

    public Parse makeMessageCell(Exception e) {
        Parse errorCell = new Parse("td", "", null, null);
        StringWriter buffer = new StringWriter();
        e.printStackTrace(new PrintWriter(buffer));
        errorCell.addToTag(" colspan=\"" + (this.columnBindings.length + 1) + "\"");
        errorCell.addToBody("<i>Unable to enter last row: " + e.getMessage() + "</i>");
        errorCell.addToBody("<pre>" + buffer.toString() + "</pre>");
        this.wrong(errorCell);
        return errorCell;
    }

    public void insertRowAfter(Parse currentRow, Parse rowToAdd) {
        Parse nextRow = currentRow.more;
        currentRow.more = rowToAdd;
        rowToAdd.more = nextRow;
    }
}

