/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fitnesse.fixtures.FitnesseFixtureContext;
import fitnesse.runner.TestRunner;
import fitnesse.wikitext.Utils;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class TestRunnerFixture {
    private String pageName;
    private String args;
    private TestRunner runner;
    private ByteArrayOutputStream outputBytes;

    public void execute() throws Exception {
        this.outputBytes = new ByteArrayOutputStream();
        this.runner = new TestRunner(new PrintStream(this.outputBytes));
        this.runner.run(this.buildArgs());
    }

    public boolean outputForPageWithArgsMatches(String page, String args, String expected) throws Exception {
        this.pageName = page;
        this.args = args;
        this.execute();
        return this.output().indexOf(expected) != -1;
    }

    private String[] buildArgs() {
        String hostName;
        LinkedList<String> list = new LinkedList<String>();
        if (this.args != null && !this.args.equals("")) {
            String[] startingArg = this.args.split(" ");
            for (int i = 0; i < startingArg.length; ++i) {
                list.add(startingArg[i]);
            }
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        list.add(hostName);
        list.add(String.valueOf(FitnesseFixtureContext.context.port));
        list.add(this.pageName);
        return list.toArray(new String[0]);
    }

    public int exitCode() {
        return this.runner.exitCode();
    }

    public String output() {
        String output = this.outputBytes.toString();
        output = output.replaceAll("\r", "");
        output = output.replaceAll("\n", "\\\\n");
        output = Utils.escapeHTML(output);
        return output;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public void setArgs(String args) {
        this.args = args;
    }
}

