/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html;

import fitnesse.html.HtmlElement;
import fitnesse.html.RawHtml;
import java.util.LinkedList;
import java.util.List;

public class HtmlTag
extends HtmlElement {
    public LinkedList<HtmlElement> childTags = new LinkedList();
    protected List<Attribute> attributes = new LinkedList<Attribute>();
    protected String tagName = "youreIt";
    public String tail;
    public String head;
    public boolean isInline;

    public HtmlTag(String tagName) {
        this.tagName = tagName;
    }

    public HtmlTag(String tagName, String content) {
        this(tagName);
        this.add(content);
    }

    public HtmlTag(String tagName, HtmlElement child) {
        this(tagName);
        this.add(child);
    }

    public String tagName() {
        return this.tagName;
    }

    public String html() {
        return this.html(0);
    }

    public String htmlInline() {
        this.isInline = true;
        return this.html(0);
    }

    public String html(int depth) {
        StringBuffer buffer = new StringBuffer();
        this.addTabs(depth, buffer);
        if (this.head != null) {
            buffer.append(this.head);
        }
        buffer.append("<").append(this.tagName());
        this.addAttributes(buffer);
        if (this.hasChildren()) {
            buffer.append(">");
            boolean tagWasAdded = this.addChildHtml(buffer, depth);
            if (tagWasAdded && !this.isInline) {
                this.addTabs(depth, buffer);
            }
            buffer.append("</").append(this.tagName()).append(">");
        } else {
            buffer.append("/>");
        }
        if (this.tail != null) {
            buffer.append(this.tail);
        }
        if (!this.isInline) {
            buffer.append(endl);
        }
        return buffer.toString();
    }

    private void addAttributes(StringBuffer buffer) {
        for (Attribute attribute : this.attributes) {
            buffer.append(" ").append(attribute.name).append("=\"").append(attribute.value).append("\"");
        }
    }

    protected void addTabs(int depth, StringBuffer buffer) {
        for (int i = 0; i < depth; ++i) {
            buffer.append('\t');
        }
    }

    private boolean addChildHtml(StringBuffer buffer, int depth) {
        boolean addedTag = false;
        boolean lastAddedWasNonTag = false;
        int i = 0;
        for (HtmlElement element : this.childTags) {
            if (element instanceof HtmlTag) {
                if ((i == 0 || lastAddedWasNonTag) && !this.isInline) {
                    buffer.append(endl);
                }
                buffer.append(((HtmlTag)element).html(depth + 1));
                addedTag = true;
                lastAddedWasNonTag = false;
            } else {
                buffer.append(element.html());
                lastAddedWasNonTag = true;
            }
            ++i;
        }
        return addedTag;
    }

    private boolean hasChildren() {
        return this.childTags.size() > 0;
    }

    public void add(String s) {
        this.add(new RawHtml(s));
    }

    public void add(HtmlElement element) {
        this.childTags.add(element);
    }

    public void addAttribute(String key, String value) {
        this.attributes.add(new Attribute(key, value));
    }

    public void use(String s) {
        this.use(new RawHtml(s));
    }

    public void use(HtmlElement element) {
        this.childTags.clear();
        this.add(element);
    }

    public String getAttribute(String key) {
        for (Attribute attribute : this.attributes) {
            if (key == null || !key.equals(attribute.name)) continue;
            return attribute.value;
        }
        return null;
    }

    public static class Attribute {
        public String name;
        public String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

