/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html;

import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageCrawlerImpl;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetupTeardownIncluder {
    private PageData pageData;
    private boolean isSuite;
    private WikiPage testPage;
    private StringBuffer newPageContent;
    private PageCrawler pageCrawler;

    public static void includeInto(PageData pageData) throws Exception {
        SetupTeardownIncluder.includeInto(pageData, false);
    }

    public static void includeInto(PageData pageData, boolean isSuite) throws Exception {
        new SetupTeardownIncluder(pageData).includeInto(isSuite);
    }

    private SetupTeardownIncluder(PageData pageData) {
        this.pageData = pageData;
        this.testPage = pageData.getWikiPage();
        this.pageCrawler = this.testPage.getPageCrawler();
        this.newPageContent = new StringBuffer();
    }

    private void includeInto(boolean isSuite) throws Exception {
        this.isSuite = isSuite;
        if (this.isTestPage()) {
            this.includeSetupAndTeardownPages();
        }
    }

    private boolean isTestPage() throws Exception {
        return this.pageData.hasAttribute("Test");
    }

    private void includeSetupAndTeardownPages() throws Exception {
        this.includeSetupPages();
        this.includeScenarioLibrary();
        this.includePageContent();
        this.includeTeardownPages();
        this.updatePageContent();
    }

    private void includeScenarioLibrary() throws Exception {
        this.includeScenarioLibrariesIfAppropriate();
    }

    private void includeSetupPages() throws Exception {
        if (this.isSuite) {
            this.includeSuiteSetupPage();
        }
        this.includeSetupPage();
    }

    private void includeSuiteSetupPage() throws Exception {
        this.include("SuiteSetUp", "-setup");
    }

    private void includeSetupPage() throws Exception {
        this.include("SetUp", "-setup");
    }

    private void includePageContent() throws Exception {
        this.newPageContent.append(this.pageData.getContent());
    }

    private void includeTeardownPages() throws Exception {
        this.includeTeardownPage();
        if (this.isSuite) {
            this.includeSuiteTeardownPage();
        }
    }

    private void includeTeardownPage() throws Exception {
        this.include("TearDown", "-teardown");
    }

    private void includeSuiteTeardownPage() throws Exception {
        this.include("SuiteTearDown", "-teardown");
    }

    private void updatePageContent() throws Exception {
        this.pageData.setContent(this.newPageContent.toString());
    }

    private void include(String pageName, String arg) throws Exception {
        WikiPage inheritedPage = this.findInheritedPage(pageName);
        if (inheritedPage != null) {
            String pagePathName = this.getPathNameForPage(inheritedPage);
            this.includePage(pagePathName, arg);
        }
    }

    private void includeScenarioLibrariesIfAppropriate() throws Exception {
        if (this.isSlim(this.testPage)) {
            this.includeScenaiorLibrariesIfAny();
        }
    }

    private void includeScenaiorLibrariesIfAny() throws Exception {
        List<WikiPage> uncles = PageCrawlerImpl.getAllUncles("ScenarioLibrary", this.testPage);
        if (uncles.size() > 0) {
            this.includeScenarioLibraries(uncles);
        }
    }

    private boolean isSlim(WikiPage page) throws Exception {
        String testSystem = page.getData().getVariable("TEST_SYSTEM");
        boolean isSlim = "slim".equalsIgnoreCase(testSystem);
        return isSlim;
    }

    private void includeScenarioLibraries(List<WikiPage> uncles) throws Exception {
        Collections.reverse(uncles);
        this.newPageContent.append("!*> Scenario Libraries\n");
        for (WikiPage uncle : uncles) {
            this.includeScenarioLibrary(uncle);
        }
        this.newPageContent.append("*!\n");
    }

    private void includeScenarioLibrary(WikiPage uncle) throws Exception {
        this.newPageContent.append("!include -c .");
        this.newPageContent.append(PathParser.render(this.pageCrawler.getFullPath(uncle)));
        this.newPageContent.append("\n");
    }

    private WikiPage findInheritedPage(String pageName) throws Exception {
        return PageCrawlerImpl.getClosestInheritedPage(pageName, this.testPage);
    }

    private String getPathNameForPage(WikiPage page) throws Exception {
        WikiPagePath pagePath = this.pageCrawler.getFullPath(page);
        return PathParser.render(pagePath);
    }

    private void includePage(String pagePathName, String arg) {
        this.newPageContent.append("\n!include ").append(arg).append(" .").append(pagePathName).append("\n");
    }
}

